import os, sys
from Ft.Rdf import Model
from Ft.Rdf.Serializers import Dom
from Ft.Lib import pDomlette

# helper functions for statement comparision
from Rdf import RdfHelper

DATABASE_NAME = os.environ.get('RDF_TEST_DB', 'test')

SOURCE_URI = ''

source = """<rdf:RDF 
  xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'
  xmlns:ns='http://my/ns#'>

  <ns:item ID='this'> <!-- typedNode -->
    <ns:prop>  <!-- propertyElt -->
      <ns:item>  <!-- typedNode -->
        <ns:prop resource='http://foo/'/>  <!-- propertyElt -->
      </ns:item> 
    </ns:prop> 
  </ns:item> 
</rdf:RDF>"""

deserialized = [
    ('#this',
     'http://www.w3.org/1999/02/22-rdf-syntax-ns#type',
     'http://my/ns#item',
     '',
     ''),
    ('ANONYMOUS0',
     'http://www.w3.org/1999/02/22-rdf-syntax-ns#type',
     'http://my/ns#item',
     '',
     ''),
    ('ANONYMOUS0',
     'http://my/ns#prop',
     'http://foo/',
     '',
     ''),
    ('#this',
     'http://my/ns#prop',
     'ANONYMOUS0',
     '',
     ''),
    ]

def Test(tester):
    tester.startTest('Initialize driver')
    driver = tester.test_data['driver']
    if driver.ExistsDb(DATABASE_NAME):
        driver.DestroyDb(DATABASE_NAME)
    driver.CreateDb(DATABASE_NAME)
    tester.testDone()
    
    tester.startTest('Property Elements')
    db = driver.GetDb('test')
    db.begin()
    model = Model.Model(db)
    serializer = Dom.Serializer()
    reader = pDomlette.PyExpatReader()
    dom = reader.fromString(source)
    serializer.deserialize(model, dom, SOURCE_URI)
    reader.releaseNode(dom)
    actual = RdfHelper.make_tuple(model.statements(), SOURCE_URI)
    tester.compare(deserialized, actual, func=RdfHelper.compare_tuple)
    db.rollback()
    tester.testDone()
    return
