#include "Python.h"
#include "domlette.h"


/*
  Internal Functions
*/

void ProcessingInstruction_ReleaseNode(PyProcessingInstructionObject *pi)
{
  Py_XDECREF(pi->piData.nodeValue);
  pi->piData.nodeValue = NULL;
  Py_XDECREF(pi->piData.target);
  pi->piData.target = NULL;
}


/*
  External Functions

*/



static struct PyMethodDef Pi_methods[] = { NODE_METHODS,CHARACTERDATA_METHODS,
  {NULL,     NULL}      /* sentinel */
};





/*
Type functions
*/

static PyObject *pi_getattr(PyProcessingInstructionObject *self, char *name)
{
  PyObject *rt = NULL;

  if (!strcmp(name,"data"))
  {
    rt = self->piData.nodeValue;
  }
  else if (!strcmp(name,"nodeValue"))
  {
    rt = self->piData.nodeValue;
  }
  else if (!strcmp(name,"target"))
  {
    rt = self->piData.target;

  }
  else if (!strcmp(name,"nodeType")) {
    rt = g_processingInstructionNodeType;
  }
  else if (!strcmp(name,"nodeName")) {
    rt = self->piData.target;
  }

  if (rt)
  {
    Py_INCREF(rt);
    return rt;
  }

  return node_getattr((PyNodeObject*)self,name,Pi_methods);
}


static void pi_dealloc(PyProcessingInstructionObject *node)
{
  Py_XDECREF(node->piData.target);
  node->piData.target = NULL;
  node_dealloc((PyNodeObject*)node);
}


void pi_build_display_string(char *buf, PyProcessingInstructionObject *v)
{
  sprintf(buf, "<cDomlette ProcessingInstruction Node at %x: target='%s>'",(long)v,PyString_AS_STRING(v->piData.target));
}


static int pi_print(PyProcessingInstructionObject *v, FILE *fp, int flags)
/* Not used but required by interface */
{
  char buf[256];
  pi_build_display_string(buf,v);
  fputs(buf, fp);
  return 0;
}

PyTypeObject PyDomletteProcessingInstruction_Type = {
    PyObject_HEAD_INIT(0)
    0,
    "cDomlette.ProcessingInstruction",
    sizeof(PyProcessingInstructionObject),
    0,
    (destructor)pi_dealloc, /*tp_dealloc*/
    (printfunc)pi_print,    /*tp_print*/
    (getattrfunc)pi_getattr,    /*tp_getattr*/
    0,              /*tp_setattr*/
    0,                          /*tp_compare*/
    0,          /*tp_repr*/
    0,                          /*tp_as_number*/
    0,              /*tp_as_sequence*/
    0,              /*tp_as_mapping*/
    0,                             /*tp_hash*/
    0,          /*tp_call*/
    0,          /*tp_str*/
    0,                      /*tp_getattro*/
    0,          /*tp_setattro*/
};


