from gtk import *
from time import strftime
from pyneheaders import *
import pynei18n

class folder_tree(GtkCTree):
	"""
	A GtkCTree specifically for showing user.contents
	mailboxes.
	"""
	def __init__(self):
		GtkCTree.__init__(self, 2, 0, [ _("Boxes"), _("Items") ] )
		self.set_column_width(0, 150)
		self.set_expander_style(CTREE_EXPANDER_SQUARE)
		self.set_line_style(CTREE_LINES_DOTTED)
		self.selected = [ None ]
		self.user_selected = [ None ]
		self.button_press_function = None
		self.cur_contents = None # remember last contents shown
					 # currently unused
		#self.open_folder_uid = None
		#self.open_folder = None

		# setup DND
		targets = [ ("pyne_boxid", 0, -1) ]
		def dnd_drag_data_get(w, context, selection_data, info, time, self=self):
			# give folder.uid
			selected = str(self.user_selected[0])
			selection_data.set(selection_data.target, 8, selected)
		self.connect("drag_data_get", dnd_drag_data_get)
		self.drag_source_set(GDK.BUTTON1_MASK|GDK.BUTTON3_MASK, targets, GDK.ACTION_MOVE)

		def click_tree_item(w, event, self=self):
			"""
			Update self.selected (list of selected folder uids)
			if anything was clicked on.
			"""
			mousebutton = event.button
			# Ignore right mouse button
			selected = w.get_selection_info(event.x, event.y)
			if selected:
				row = selected[0]
				node = self.node_nth(row)
				box = self.node_get_row_data(node)
				# Remember selected item
				self.selected = [ box ]
				self.user_selected = [ box ]
			# Call secondary event handler
			if self.button_press_function != None:
				self.button_press_function(w, event, self)

		self.connect("button_press_event", click_tree_item)

	def connect_button_press_event(self, function):
		"""
		Allow "button_press_event"s to be passed to a secondary
		function for things like right click menus and doing more
		than just remembering what is selected :-)
		"""
		self.button_press_function = function

	def update(self, contents, update_all=0):
		"""
		Update view of mailboxes... :-/
		contents=None if just update currently shown.
		"""
		self.freeze()

		if contents == None and self.cur_contents != None:
			contents = self.cur_contents
		# remember last contents shown
		self.cur_contents = contents

		if update_all == 1:
			# Remember folders are expanded (uids)
			expanded = []
			i = 0
			while (self.node_nth(i) != None):
				node = self.node_nth(i)
				id = self.node_get_row_data(node)
				# get expanded
				try:
					_exp = self.get_node_info(node)[7]
				except ValueError:
					# This should never happen, and never
					# happens to me but has been reported.
					# *shrug* XXX XXX XXX XXX XXX XXX XXX
					i = i + 1
					print "Whoops on id ", id
					continue
				if _exp == TRUE:
					expanded.append(id)
				i = i + 1
			while self.node_nth(0) != None:
				# remove node
				self.remove_node( self.node_nth(0) )
			# root node
			rootnode = self.insert_node(None, None, [ _("User"), str(len(contents)) ], 0, None, None, None, None, FALSE, TRUE)
			self.node_set_row_data(rootnode, "__rootnode")
			# Make junk
			def _recurse_make(objects, rootnode, _recurse_make, expanded=expanded, self=self):
				for y in range(0,len(objects)):
					x = objects[y]
					stats = x.getstats()
					# Keep selected item open some time XXX XXX
					if x.uid in expanded:
						_exp = TRUE
					else:
						_exp = FALSE
					node = self.insert_node(rootnode, None, [ x.name, str(stats[0]) ], 0, None, None, None, None, FALSE, _exp)
					self.node_set_row_data(node, x.uid)
					if x.__dict__.has_key("contents"):
						_recurse_make(x.contents, node, _recurse_make)
			_recurse_make(contents, rootnode, _recurse_make)
			self.selected = [ None ]

		else:
			# Partial update
			def _recurse_update(objects, _recurse_update, self=self):
				for y in range(0,len(objects)):
					x = objects[y]
					# only update changed stuff
					if x.__dict__.has_key("changed"):
						stats = x.getstats()
						# find it's node in the ctree
						node = self.find_by_row_data(None, x.uid)
						self.node_set_text(node, 0, x.name)
						self.node_set_text(node, 1, str(stats[0]))
					# sub-folders. this mess could be recursive
					if x.__dict__.has_key("contents"):
						_recurse_update(x.contents, _recurse_update)
			_recurse_update(contents, _recurse_update)
		# Whoohoo. defrost widget :-\
		self.thaw()
