#
# Nice old pyne mailboxes. bodies in a shelve database indexed
# by message-id, and headers similarly done.
#

import shelve
import marshal
import os
from pyneheaders import *
from superbox import superbox

class pynebox(superbox):
	def __init__(self, user, parent_messagebox):
		self.user = user
		self.header_db = shelve.open(str(parent_messagebox.uid)+".hdr")
		self.body_db = shelve.open(str(parent_messagebox.uid)+".bdy")
		self.prefix = str(parent_messagebox.uid)

	def get_contents(self):
		return self.header_db.keys()

	def nuke(self):
		"""
		Delete database entirely.
		"""
		self.header_db.close()
		self.body_db.close()
		os.remove(self.prefix+".hdr")
		os.remove(self.prefix+".bdy")

	def __del__(self):
		self.header_db.close()
		self.body_db.close()

	def load_header(self, msg_id):
		"""
		Return message header or None if not found. in form:
		(date, date_received, message-id, references,
		subject, from, type, isread, isreplied, senduid)
		"""
		try:
			return marshal.loads(self.header_db[msg_id])
		except (TypeError,KeyError):
			return None

	def _load_article(self, msg_id):
		"""
		Returm body for message 'msg_id'.
		"""
		try:
			header = marshal.loads(self.header_db[msg_id])
		except (TypeError,KeyError):
			header = None
		try:
			body = self.body_db[msg_id]
		except KeyError:
			body = None
		return (header, body)

	def _save_article(self, headers, body_text, msg_id):
		"""
		Do not use directly. use save_article.
		"""
		self.header_db[msg_id] = marshal.dumps(headers)
		self.body_db[msg_id] = body_text

	def delete_article(self, msg_id):
		try:
			del self.header_db[msg_id]
		except KeyError:
			pass
		try:
			del self.body_db[msg_id]
		except KeyError:
			pass

	def has_article(self, msg_id):
		"""
		Is the article cached?
		"""
		# NOTE: we check for presence of headers not bodies
		if self.header_db.has_key(msg_id):
			return 1
		else:
			return 0


