#
# A simple address book for pyne
#

import utils
from gtk import *
import string
import pynei18n

class PynePerson:
	"""
	Whoohoo.
	"""
	def __init__(self):
		self.realname = ""
		self.phone_1 = ""
		self.emailaddr = ""
		self.note = ""

class AddressBook:
	"""
	Allows storing of names with associated email addresses.
	"""
	def __init__(self):
		self.addresses = []

		# each address is in the form:
		# [ "real name", "email address", "note" ]

	def add_senders_address(self, msg, addr_editbox):
		"""
		Add the sender of a message to the address book.
		"""
		if msg.headers.has_key("reply-to"):
			realname, emailaddress = utils.split_address(msg.headers["reply-to"])
		else:
			realname, emailaddress = utils.split_address(msg.headers["from"])
		self.addresses.append( [ realname, emailaddress, "" ] )
		addr_editbox.update_entry_list()
		addr_editbox.edit_address(index=len(self.addresses)-1)

	def sort(self):
		"""
		Sort address book by alphabetic order
		"""
		def _sort(a, b):
			a_name = string.split(string.lower(a[0]), " ")
			b_name = string.split(string.lower(b[0]), " ")

			# find last names
			a_lastname = a_name[len(a_name)-1]
			b_lastname = b_name[len(b_name)-1]

			if a_lastname < b_lastname:
				return -1
			elif a_lastname > b_lastname:
				return 1
			else:
				# same last name. decide by first name
				if a_name[0] < b_name[0]:
					return -1
				elif a_name[0] > b_name[0]:
					return 1
				# equal :-o
				return 0

		self.addresses.sort(_sort)

class AddressEditBox:
	"""
	A box allowing the editing of the address book and
	also selection of an entry by means of connecting
	'clicked' on ok_button.
	If gtkentry is set then the selected address will be
	dumped in usable form to the specified gtkentry. if append=1
	then it will be appended to existing contents.
	"""
	def __init__(self, addressbook, gtkentry=None, append=0):
		self.addressbook = addressbook
		self.gtkentry = gtkentry
		self.append = append

		self.win = GtkWindow()
		self.win.set_default_size(600,440)
		self.win.set_title(_("Address Book"))

		box1 = GtkVBox()
		box1.set_border_width(2)
		self.win.add(box1)
		box1.show()

		def _on_click(widget, event, self=self):
			"""
			If someone double-clicks on an address return it.
			"""
			if event.type == GDK._2BUTTON_PRESS:
				selected = widget.get_selection_info(event.x, event.y)
				if not selected:
					return
				index = selected[0]
				addr =  self.addressbook.addresses[index]
				if self.gtkentry != None:
					if self.append == 0:
						# push in form: "name" <email@ddress>
						s = "\""+addr[0]+"\" <"+addr[1]+">"
						self.gtkentry.set_text(s)
					else:
						s = "\""+addr[0]+"\" <"+addr[1]+">"
						if self.gtkentry.get_text() != "":
							s = self.gtkentry.get_text() + ", " + s
						self.gtkentry.set_text(s)
				self.win.destroy()

		self.entry_list = GtkCList(3, [ _("Name"), _("Email Address"), _("Notes")] )
		self.entry_list.set_column_width(0, 150)
		self.entry_list.set_column_width(1, 250)
		self.entry_list.set_column_width(2, 150)
		self.entry_list.connect("button_press_event", _on_click)
		self.update_entry_list()

		swin = GtkScrolledWindow()
		swin.set_policy(POLICY_AUTOMATIC, POLICY_AUTOMATIC)
		box1.pack_start(swin)
		swin.show()
		swin.add(self.entry_list)
		self.entry_list.show()

		##### BOX3. Buttons
		box3 = GtkHBox(spacing=5)
		box3.set_border_width(5)
		box1.pack_start(box3, expand=FALSE)
		box3.show()

		button = GtkButton(" "+_("Close")+" ")
		button.connect("clicked", self.win.destroy)
		box3.pack_end(button, expand=FALSE)
		button.show()

		def del_address(_button, self=self):
			"""
			Add an address.
			"""
			if len(self.entry_list.selection) > 0:
				index = self.entry_list.selection[0]

				del self.addressbook.addresses[index]
				self.update_entry_list()

		button = GtkButton(" "+_("Delete")+" ")
		button.connect("clicked", del_address)
		box3.pack_end(button, expand=FALSE)
		button.show()

		button = GtkButton(" "+_("Edit")+" ")
		button.connect("clicked", self.edit_address)
		box3.pack_end(button, expand=FALSE)
		button.show()

		def add_address(_button, self=self):
			"""
			Add an address.
			"""
			self.addressbook.addresses.append(["","",""])
			self.update_entry_list()
			self.edit_address(index=len(self.addressbook.addresses)-1)

		button = GtkButton(" "+_("Add")+" ")
		button.connect("clicked", add_address)
		box3.pack_end(button, expand=FALSE)
		button.show()

		def dump_address(_button, self=self):
			addr = self.get_selected()
			if self.append == 0:
				# push in form: "name" <email@ddress>
				s = "\""+addr[0]+"\" <"+addr[1]+">"
				self.gtkentry.set_text(s)
			else:
				s = "\""+addr[0]+"\" <"+addr[1]+">"
				if self.gtkentry.get_text() != "":
					s = self.gtkentry.get_text() + ", " + s
				self.gtkentry.set_text(s)
			self.win.destroy()
				

		self.ok_button = GtkButton( " "+_("Ok")+" ")
		if gtkentry != None:
			self.ok_button.connect("clicked", dump_address)
		box3.pack_end(self.ok_button, expand=FALSE)
		self.ok_button.show()

		self.win.show()

	def edit_address(self, _button=0, index=-1):
		"""
		Edit an existing entry.
		"""
		if (len(self.entry_list.selection) > 0) and (index==-1):
			index = self.entry_list.selection[0]
		if index == -1:
			return

		entry = self.addressbook.addresses[index]

		win = GtkWindow()
		win.set_title(_("Pyne - Edit Address"))
		box = GtkVBox()
		win.add(box)
		box.show()

		box1 = GtkHBox()
		box.pack_start(box1)
		box1.show()
		box1_1 = GtkVBox(spacing=5)
		box1_1.set_border_width(5)
		box1.pack_start(box1_1)
		box1_1.show()
		box1_2 = GtkVBox(spacing=5)
		box1_2.set_border_width(5)
		box1.pack_start(box1_2)
		box1_2.show()

		label = GtkLabel(_("Name"))
		box1_1.pack_start(label)
		label.show()
		label = GtkLabel(_("Email Address"))
		box1_1.pack_start(label)
		label.show()
		label = GtkLabel(_("Note"))
		box1_1.pack_start(label)
		label.show()

		name_entry = GtkEntry()
		box1_2.pack_start(name_entry)
		name_entry.set_text(entry[0])
		name_entry.show()
		addr_entry = GtkEntry()
		box1_2.pack_start(addr_entry)
		addr_entry.set_text(entry[1])
		addr_entry.show()
		note_entry = GtkEntry()
		box1_2.pack_start(note_entry)
		note_entry.set_text(entry[2])
		note_entry.show()

		box2 = GtkHBox(spacing=5)
		box2.set_border_width(5)
		box.pack_end(box2, expand=FALSE)
		box2.show()

		def make_it_so(_button, self=self, name_entry=name_entry, index=index, \
		                addr_entry=addr_entry, note_entry=note_entry, win=win):
			name = name_entry.get_text()
			addr = addr_entry.get_text()
			note = note_entry.get_text()
			if name=="" and addr=="" and note=="":
				del self.addressbook.addresses[index]
			else:
				self.addressbook.addresses[index] = [ name,addr,note ]
			self.addressbook.sort()
			self.update_entry_list()
			
			win.destroy()

		def _cancel_edit(_button, self=self, index=index, win=win):
			# if this was a new address delete it
			name, addr, note = self.addressbook.addresses[index]
			if name=="" and addr=="" and note=="":
				del self.addressbook.addresses[index]
				self.addressbook.sort()
				self.update_entry_list()
			win.destroy()

		button = GtkButton(" "+_("Cancel")+" ")
		button.connect("clicked", _cancel_edit)
		box2.pack_end(button, expand=FALSE)
		button.show()
		button = GtkButton(" "+_("Ok")+" ")
		button.connect("clicked", make_it_so)
		box2.pack_end(button, expand=FALSE)
		button.show()
				
		win.show()

	def update_entry_list(self):
		"""
		Update the list of addresses.
		"""
		entry_list = self.entry_list
		x = len(self.addressbook.addresses)
		entry_list.clear()
		addresses = self.addressbook.addresses

		for y in range(0, x):
			a = [ addresses[y][0], addresses[y][1], addresses[y][2] ]
			entry_list.append(a)

	def get_selected(self):
		"""
		Return currently selected address.
		"""
		if len(self.entry_list.selection) == 0:
			return [ "", "", "" ]
		else:
			index = self.entry_list.selection[0]
			return self.addressbook.addresses[index]

	def destroy(self):
		self.win.destroy()

