/*
 * inotify.c - python interface to inotify (pyinotify)
 * Copyright (C) 2005-2006  Sbastien Martini <sebastien.martini@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 */

#include <Python.h>
#include <sys/syscall.h>
#include "inotify_syscalls.h"


static PyObject*
inotify_init(PyObject* self, PyObject* args)
{
  int result;

  if(!PyArg_ParseTuple(args, ""))
    return 0;
  result = syscall(__NR_inotify_init);
  return Py_BuildValue("i", result);
}


static PyObject*
inotify_add_watch(PyObject* self, PyObject* args)
{
  int fd;
  char* name;
  unsigned int mask;
  int result;

  if(!PyArg_ParseTuple(args, "isI", &fd, &name, &mask))
    return 0;
  result = syscall(__NR_inotify_add_watch, fd, name, mask);
  return Py_BuildValue("i", result);
}


static PyObject*
inotify_rm_watch(PyObject* self, PyObject* args)
{
  int fd;
  unsigned int wd;
  int result;

  if(!PyArg_ParseTuple(args, "iI", &fd, &wd))
    return 0;
  result = syscall(__NR_inotify_rm_watch, fd, wd);
  return Py_BuildValue("i", result);
}


static PyMethodDef inotifyFunctions[] = {
  {"inotify_init", inotify_init, METH_VARARGS, "inotify initialization"},
  {"inotify_add_watch", inotify_add_watch, METH_VARARGS, "add a watch"},
  {"inotify_rm_watch", inotify_rm_watch, METH_VARARGS, "remove a watch"},
  {0}
};


void
init_inotify(void)
{
  Py_InitModule3("_inotify", inotifyFunctions, "module _inotify");
}

