import os, sys, files
from mkincl import *

GCC = '/usr/bin/gcc'

processor = sys.argv[1]


g = open('dyn-Makefile', 'w')
print >> g, "# automatically generated by depend.py"
print >> g
print >> g, "O_FILES =",

basenames = []
for f in files.SRC:
    assert f.filename.endswith('.c')
    basenames.append(f.filename[:-2])
for f in files.PROCESSOR_SRC[processor]:
    assert f.filename.endswith('.c')
    basenames.append(processor + '/' + f.filename[:-2])

for fn in basenames:
    print >> g, fn+'.o',
print >> g
print >> g

for fn in basenames:
    print fn
    h = os.popen("%s -I%s %s -M -Wundef %s.c" % (GCC, processor,
                                                  INCLUDE_STR, fn), 'r')
    data = h.read()
    h.close()
    data = data.replace('\\\n', ' ')
    data = data[data.index(':')+1:]
    data = data.strip().split()
    data = map(os.path.normpath, data)
    found = {}
    print >> g, '%s.o:' % fn,
    for f1 in data:
        if f1 not in found and not f1.startswith('/'):
            print >> g, f1,
            found[f1] = 1
    print >> g
    print >> g
