/*
    NSStringAdditions.m

    Implementation of additions to the NSString class for the
    ProjectManager application.

    Copyright (C) 2005  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#import "NSStringAdditions.h"

@implementation NSString (PMAdditions)

- (unsigned int) endOfLineAtIndex: (unsigned int) i
{
  SEL sel = @selector(characterAtIndex:);
  unichar (*charAtIndex)(id, SEL, unsigned int) =
    (unichar (*)(id, SEL, unsigned int))[self methodForSelector: sel];
  unsigned int n;

  n = [self length];
  for (; i < n; i++)
    {
      unichar c = charAtIndex(self, sel, i);

      if (c == '\n' || c == '\r')
        {
          return i;
        }
    }

  // end of string hit - just return the end of the string as the EOL
  return i;
}

- (BOOL) containsString: (NSString *) aString
{
  return ([self rangeOfString: aString].location != NSNotFound);
}

@end
