/*
    StringValidation.h

    Utilities useful various kinds of validations of strings for
    the ProjectManager application.

    Copyright (C) 2006  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#import <Foundation/NSString.h>

/**
 * Makes sure that the argument is a non-empty string. This feature
 * is often used in attributes where an empty string value symbolizes
 * an undefined value of the attribute, but passing `nil' would be
 * desirable. This function does exactly that.
 *
 * @param argument The string which to check.
 *
 * @return The argument, if the string is not empty (not zero-length),
 *      or `nil' if it is.
 */
static inline NSString *
NonEmptyString(NSString * argument)
{
  if ([argument length])
    {
      return argument;
    }
  else
    {
      return nil;
    }
}
