/* $Cambridge: hermes/src/prayer/cmd/cmd_abook_xfer.c,v 1.2 2008/05/19 15:55:54 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

#include "prayer_session.h"

/* Transfer addressbook to/from local system */

static void generate_form(struct session *session)
{
    struct template_vals *tvals = session->template_vals;
    struct request *request = session->request;
    struct buffer *b = request->write_buffer;

    /* Miscelleneous Actions 2 */
    if (session->accountd_server && session->accountd_server[0])
        template_vals_ulong(tvals, "local_pine_abook", 1);

    session_seed_template(session, tvals);
    template_expand("abook_transfer", tvals, b);
    response_html(request, 200);        /* Success */
}

/* ====================================================================== */

/* Export Pine format addressbook */

static BOOL export_pine(struct session *session)
{
    struct request *request = session->request;
    struct options *options = session->options;
    struct abook *abook = options->abook;
    struct buffer *b = request->write_buffer;
    char *name = "addressbook";

    bprintf(b, "# Prayer addressbook for %s\n", session->username);
    abook_export_pine(abook, b);

    response_raw(request, name, "application/octet-stream", 200);

    return (T);
}

/* ====================================================================== */

/* Export CSV (Outlook format) addressbook */

static BOOL export_csv(struct session *session)
{
    struct request *request = session->request;
    struct options *options = session->options;
    struct abook *abook = options->abook;
    struct buffer *b = request->write_buffer;
    char *name = "addressbook";

    abook_export_csv(abook, b);

    response_raw(request, name, "application/octet-stream", 200);

    return (T);
}

/* ====================================================================== */

void cmd_abook_xfer(struct session *session)
{
    struct request *request = session->request;
    char *start, *end;

    if (request->method != POST) {
        if ((request->argc >= 2) && !strcmp(request->argv[1], "export")) {
            export_pine(session);
            return;
        }
        if ((request->argc >= 2) && !strcmp(request->argv[1], "export_csv")) {
            export_csv(session);
            return;
        }
        generate_form(session);
        return;
    }

    if (request->argc < 2) {
        session_redirect(session, request, "error");
        return;
    }

    request_decode_post_multipart(request, NIL, &start, &end);
    *end = '\0';

    if (abook_import_csv_valid(start)) {
        struct abook *abook = session->options->abook;
        unsigned long count = abook_import_csv(abook, start);

        if (count != 1)
            session_message(session, "Imported %lu aliases", count);
        else
            session_message(session, "Imported 1 alias");

        if (count > 0)
            session->options->save = T;
    } else if (!strncmp(start, "First Name\tLast Name\t",
                        strlen("First Name\tLast Name\t"))) {
        /* XXX Test XXX */
        session_message(session,
                        "Old format Outlook addressbooks not supported");
    } else if (abook_import_pine_valid(start)) {
        struct abook *abook = session->options->abook;
        unsigned long count = abook_import_pine(abook, start);

        if (count != 1)
            session_message(session, "Imported %lu aliases", count);
        else
            session_message(session, "Imported 1 alias");

        if (count > 0)
            session->options->save = T;
    } else
        session_message(session, "Invalid/Unsupported addressbook format");

    session_redirect(session, request, "abook_list");
}
