#ifndef	RADIUS_H
#define	RADIUS_H

#define	DEFAULT_RADIUS_PORT		1645
#define	LEN_AUTH_FIELD			16
#define	LEN_AUTH_PASSWD			16
#define	LEN_RADIUS_PACKET		4096

#define	CODE_ACCESS_REQUEST		1
#define	CODE_ACCESS_ACCEPT		2
#define	CODE_ACCESS_REJECT		3
#define	CODE_ACCOUNTING_REQUEST		4
#define	CODE_ACCOUNTING_RESPONSE	5
#define	CODE_ACCESS_CHALLENGE		11

#define	TYPE_USER_NAME			1
#define	TYPE_USER_PASSWD		2
#define	TYPE_CHAP_PASSWD		3
#define	TYPE_NAS_IP_ADDRESS		4
#define	TYPE_NAS_PORT			5
#define	TYPE_SERVICE_TYPE		6
#define	TYPE_FRAMED_PROTOCOL		7
#define	TYPE_FRAMED_IP_ADDRESS		8
#define	TYPE_FRAMED_IP_NETMASK		9
#define	TYPE_FRAMED_ROUTING		10
#define	TYPE_FILTER_ID			11
#define	TYPE_FRAMED_MTU			12
#define	TYPE_FRAMED_COMPRESSION		13
#define	TYPE_LOGIN_IP_HOST		14
#define	TYPE_LOGIN_SERVICE		15
#define	TYPE_LOGIN_TCP_PORT		16
#define	TYPE_REPLY_MESSAGE		18
#define	TYPE_CALLBACK_NUMBER		19
#define	TYPE_CALLBACK_ID		20
#define	TYPE_FRAMED_ROUTE		22
#define	TYPE_FRAMED_IPX_NETWORK		23
#define	TYPE_STATE			24
#define	TYPE_CLASS			25
#define	TYPE_VENDOR_SPECIFIC		26
#define	TYPE_SESSION_TIMEOUT		27
#define	TYPE_IDLE_TIMEOUT		28
#define	TYPE_TERMINATION_ACTION		29
#define	TYPE_CALLED_STATION_ID		30
#define	TYPE_CALLING_STATION_ID		31
#define	TYPE_NAS_IDENTIFIER		32
#define	TYPE_PROXY_STATE		33
#define	TYPE_LOGIN_LAT_SERVICE		34
#define	TYPE_LOGIN_LAT_NODE		35
#define	TYPE_LOGIN_LAT_GROUP		36
#define	TYPE_FRAMED_APPLETALK_LINK	37
#define	TYPE_FRAMED_APPLETALK_NETWORK	38
#define	TYPE_FRAMED_APPLETALK_ZONE	39

#define	TYPE_ACCT_STATUS_TYPE		40
#define	TYPE_ACCT_DELAY_TIME		41
#define	TYPE_ACCT_INPUT_OCTETS		42
#define	TYPE_ACCT_OUTPUT_OCTETS		43
#define	TYPE_ACCT_SESSION_ID		44
#define	TYPE_ACCT_AUTHENTIC		45
#define	TYPE_ACCT_SESSION_TIME		46
#define	TYPE_ACCT_INPUT_PACKETS		47
#define	TYPE_ACCT_OUTPUT_PACKETS	48
#define	TYPE_ACCT_TERMINATE_CAUSE	49
#define	TYPE_ACCT_MULTI_SESSION_ID	50
#define	TYPE_ACCT_LINK_COUNT		51

#define	TYPE_CHAP_CHALLENGE		60
#define	TYPE_NAS_PORT_TYPE		61
#define	TYPE_PORT_LIMIT			62
#define	TYPE_LOGIN_LAT_PORT		63
#define	TYPE_MAX			63

/*
 * Service Types
 */

#define	SERVICE_LOGIN			1
#define	SERVICE_FRAMED			2
#define	SERVICE_CALLBACK_LOGIN		3
#define	SERVICE_CALLBACK_FRAMED		4
#define	SERVICE_OUTBOUND		5
#define	SERVICE_ADMINISTRATIVE		6
#define	SERVICE_NAS_PROMPT		7
#define	SERVICE_AUTHENTICATE_ONLY	8
#define	SERVICE_CALLBACK_NAS_PROMPT	9

/*
 * Framed Protocol
 */

#define	FRAMED_PPP			1
#define	FRAMED_SLIP			2
#define	FRAMED_ARAP			3
#define	FRAMED_GANDALF			4
#define	FRAMED_XYLOGICS			5

/*
 * Framed IP Address
 */

#define	IPADDRESS_USER		0xffffffff
#define	IPADDRESS_NAS		0xfffffffe

#endif
