#
#
#
#

set note_proc(add)		note:add
set note_proc(page)		note:page
set note_proc(select)		note:select
set note_proc(unselect)		note:unselect
set note_proc(fixsize)		note:fixsize

Widget:DefineClass NoteBook {} note:create note:config note_proc

set note_max_pages 16

proc note:create {w a} {
    global note_page_list note_max_pages note_config

    set note_page_list($w) {}
    set note_config($w,borderwidth) 2
    frame $w.blank
    grid $w.blank -column 0 -columnspan [expr $note_max_pages*3 + 1] \
	-row 3 -rowspan 1 -sticky ewns

    grid rowconfigure $w 0 -weight 0 -minsize $note_config($w,borderwidth)
    grid rowconfigure $w 1 -weight 0
    grid rowconfigure $w 2 -weight 0 -minsize $note_config($w,borderwidth)
    grid rowconfigure $w 3 -weight 1

    grid columnconfigure $w [expr $note_max_pages*3] -weight 100

    return $w
}

proc note:config {w opt val} {
    return 0
}

proc note:add {w a} {
    global note_page_list note_page_id note_max_pages note_config

    set page [shift a]
    set id [llength $note_page_list($w)]

    set note_page_id($page) $id
    lappend note_page_list($w) $page

    set bd $note_config($w,borderwidth)

    set rel  [frame $w.relief$id -relief raised -borderwidth $bd]
    set tag  [button $w.tag$id -relief flat -borderwidth 0 -padx 0 -pady 0]
    set mask [frame $w.mask$id -relief flat -borderwidth 0 -height $bd]
    set page [frame $page -relief raised -borderwidth $bd]

    set tagtext [option get $page tag {}]
    if {$tagtext != ""} {
	$tag configure -text $tagtext
    }
    set c [expr $id*3]
    grid $rel  -column [expr $c+0] -columnspan 3 -row 0 -rowspan 3 \
	-sticky ewns
    grid $tag  -column [expr $c+1] -columnspan 1 -row 1 -rowspan 1 \
	-sticky ""
    grid $mask -column [expr $c+1] -columnspan 1 -row 2 -rowspan 1 \
	-sticky ewns
    grid $page -column 0 -columnspan [expr $note_max_pages*3+1] \
	-row 2 -rowspan 2 -sticky ewns

    grid columnconfigure $w [expr $c+0] -weight 0 -minsize $bd
    grid columnconfigure $w [expr $c+1] -weight 1
    grid columnconfigure $w [expr $c+2] -weight 0 -minsize $bd

    lower $rel  $w.blank
    raise $tag  $rel
    raise $page $rel
    lower $mask $rel

    note:page_config $w $page $a

    $tag configure -command [list note:select $w $page]

    return $page
}

proc note:page_config {w page a} {
    global note_page_id

    set id $note_page_id($page)

    while {[llength $a] > 0} {
	set o [shift a]
	set v [shift a]
	switch -- $o {
	    -tag {
		$w.tag$id configure -text $v
	    }
	}
    }
}
proc note:unselect {w a} {
    global note_page_id

    set page [shift a]
    set i $note_page_id($page)
    if {$i > 0} {
	set j [expr $i - 1]
	lower $w.relief$i $w.relief$j
    }
    raise $w.tag$i  $w.relief$i
    lower $w.mask$i $w.blank
#    lower $page $w.blank

    grid $w.relief$i -column [expr $i*3] -columnspan 3
    grid $w.mask$i -column [expr $i*3+1] -columnspan 1

    grid remove $page
}

proc note:select {w a} {
    global note_page_list note_page_id

    foreach p $note_page_list($w) {
	note:unselect $w $p
    }
    set page [shift a]
    set i $note_page_id($page)
    if {$i > 0} {
	set j [expr $i - 1]
	raise $w.relief$i $w.relief$j
    }
    raise $w.tag$i  $w.relief$i
    raise $page     $w.blank
    raise $w.mask$i $page

    set c [expr $i*3]
    if {$c > 0} {
	grid $w.relief$i -column [expr $c - 1] -columnspan 5
	grid $w.mask$i -column $c -columnspan 3
    } else {
	grid $w.relief$i -column $c -columnspan 4
	grid $w.mask$i -column [expr $c + 1] -columnspan 1
    }
    grid $page
}

proc note:fixsize {w a} {
    set is_fix [shift a]

    if $is_fix {
	update idletasks
	grid propagate $w 0
    } else {
	grid propagate $w 1
    }
}

proc note:test {} {
    NoteBook .note

    set page0 [.note add .note.page0 -tag "page0"]
    set page1 [.note add .note.page1 -tag "page1"]
    set page2 [.note add .note.page2 -tag "page2"]

    label .note.page0.label -text "Label"
    button .note.page0.button -text "Button"
    pack .note.page0.label .note.page0.button -side top

    .note select .note.page0

    pack .note

    .note fixsize 1
}
