/***************************************************************************
 *                                                                         *
 *                         Powersave Daemon                                *
 *                                                                         *
 *          Copyright (C) 2004,2005 SUSE Linux Products GmbH               *
 *                                                                         *
 * This program is free software; you can redistribute it and/or modify it *
 * under the terms of the GNU General Public License as published by the   *
 * Free Software Foundation; either version 2 of the License, or (at you   *
 * option) any later version.                                              *
 *                                                                         *
 * This program is distributed in the hope that it will be useful, but     *
 * WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       *
 * General Public License for more details.                                *
 *                                                                         *
 * You should have received a copy of the GNU General Public License along *
 * with this program; if not, write to the Free Software Foundation, Inc., *
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA                  *
 *                                                                         *
 ***************************************************************************/

#include "config.h"
#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>

#include <sys/ioctl.h>
#include <sys/stat.h>
#include <linux/major.h>
#include <linux/hdreg.h>

#include "powerlib.h"
#include "powerlib_local.h"
#include "string.h"

#define ACPI_LID_DIR "/proc/acpi/button/lid"

/*returns:
  NO_ACPI_ERROR
  NO_MODULE_ERROR -> no /proc/acpi/button/lid directory => no lid switch.
  lower than zero or UNKNOWN == error */

int getLidState(void)
{
	/* differ between several kernel implementations (where is the proc entry) here */
	char value[MAX_LINE_SIZE + 1] = "";
	char temp[MAX_LINE_SIZE + 1] = "";
	char file[MAX_FILE_PATH + 1] = "";

	FILE *rdFile = NULL;
	int res;

	if (checkACPI() != ACPI)
		return NO_ACPI_ERROR;

	if (access(ACPI_LID_DIR, F_OK)) {
		return NO_MODULE_ERROR;
	}
	if (getDirEntry(0, value, sizeof(value), ACPI_LID_DIR) < 0) {
		pDebug(DBG_DIAG, "no entry in %s", ACPI_LID_DIR);
		goto ERROR;
	}
	/* possible to overwrite file ?!? */
	res = snprintf(file, MAX_FILE_PATH, "%s/%s/state", ACPI_LID_DIR, value);
	if (res >= MAX_FILE_PATH) {
		pDebug(DBG_DIAG, "path too long: %s/%s/state", ACPI_LID_DIR, value);
		goto ERROR;
	}
	pDebug(DBG_INFO, "Lid state file: %s", file);
	rdFile = fopen(file, "r");
	if (!rdFile) {
		pDebug(DBG_DIAG, "Could not open %s", file);
		goto ERROR;
	}

	if (getColonValue(rdFile, value, sizeof(value), temp, sizeof(temp)) < 0) {
		pDebug(DBG_DIAG, "parsing %s failed. Please report.", file);
		goto ERROR;
	} else {
		pDebug(DBG_INFO, "Value: %s", value);
		fclose(rdFile);
		rdFile = NULL;
		if (!strcmp(value, "open"))
			return LID_OPEN;
		else if (!strcmp(value, "closed"))
			return LID_CLOSED;
		else {
			pDebug(DBG_DIAG, "parsing %s failed. Please report.", file);
			goto ERROR;
		}
	}

      ERROR:
	if (rdFile)
		fclose(rdFile);
	return UNKNOWN;
}
