/***************************************************************************
 *                                                                         *
 *                         Powersave Daemon                                *
 *                                                                         *
 *          Copyright (C) 2004,2005 SUSE Linux Products GmbH               *
 *                                                                         *
 *               Author(s): Holger Macht <hmacht@suse.de>                  *
 *                                                                         *
 * This program is free software; you can redistribute it and/or modify it *
 * under the terms of the GNU General Public License as published by the   *
 * Free Software Foundation; either version 2 of the License, or (at you   *
 * option) any later version.                                              *
 *                                                                         *
 * This program is distributed in the hope that it will be useful, but     *
 * WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       *
 * General Public License for more details.                                *
 *                                                                         *
 * You should have received a copy of the GNU General Public License along *
 * with this program; if not, write to the Free Software Foundation, Inc., *
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA                  *
 *                                                                         *
 ***************************************************************************/

#ifndef THROTTLE_INTERFACE_H
#define THROTTLE_INTERFACE_H

class EventManagement;

/** @brief used to evaluate whether to throw a processor.idle or
 * processor.busy event */
enum PROCESSOR_EVENT_STATE { PROCESSOR_BUSY_THROWN,
			     PROCESSOR_IDLE_THROWN,
			     NO_PROCESSOR_EVENT_THROWN };

/** @brief class caring about throttling the cpu while load changes */
class ThrottleInterface {
public:
	/** @brief constructor */
	ThrottleInterface();

	/** @brief checks all cpus whether they should get throttled
	 *
	 * @return false if something went wrong, true otherwise */
	bool updateCPUState(EventManagement *eM);

	/** @brief throttles cpus
	 *
	 * @param percent throttle cpus to that percentage
	 *        -1 means maximum throttling
	 * @return true if throttling supported, false otherwise
	 */
	bool throttle(int percent = -1);

	/** @brief dethrottles cpus
	 *
	 * @return true if throttling supported, false otherwise
	 */
	bool dethrottle();

	/** @brief resets the object and clears all local values
	 *
	 * this may be used to start evaluating from the beginning */
	void restart();

	/** @brief disables throttling */
	void disableThrottling();

private:
	/** @brief timeout when processor.low event should be thrown
	 * if it stays under the limit for this time */
	unsigned long _msecs_cpu_idle;

	/** @brief whether cpu is currently idle
	 *
	 * this does not reflect whether the cpu is throttled. This
	 * variable has to be true long enough for the cpu being throttled
	 */
	bool _cpu_is_idle;

	/** @brief indicates whether an processor event was thrown
	 *
	 * value of 1 indicates that processor.low event
	 * has been thrown, value of 0 indicates, that it
	 * has not thrown till now
	 */
	PROCESSOR_EVENT_STATE _event_state;

	/** @brief defines whether throttling is supported */
	bool _throttling_supported;
};

#endif // THROTTLE_INTERFACE_H
