/***************************************************************************
 *                                                                         *
 *                         Powersave Daemon                                *
 *                                                                         *
 *          Copyright (C) 2004,2005 SUSE Linux Products GmbH               *
 *                                                                         *
 *               Author(s): Holger Macht <hmacht@suse.de>                  *
 *                                                                         *
 * This program is free software; you can redistribute it and/or modify it *
 * under the terms of the GNU General Public License as published by the   *
 * Free Software Foundation; either version 2 of the License, or (at you   *
 * option) any later version.                                              *
 *                                                                         *
 * This program is distributed in the hope that it will be useful, but     *
 * WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       *
 * General Public License for more details.                                *
 *                                                                         *
 * You should have received a copy of the GNU General Public License along *
 * with this program; if not, write to the Free Software Foundation, Inc., *
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA                  *
 *                                                                         *
 ***************************************************************************/

#ifndef BATTERY_H
#define BATTERY_H

#include "powerlib.h"

class EventManagement;

/** @brief used for different states of cpu, battery and temperature!
 *
 * Do not change order as it is used to evaluate whether a higher or lower
 * battery state is reached
 */
enum BATTERY_STATES { BAT_CRIT_STATE, BAT_LOW_STATE, BAT_WARN_STATE, BAT_NORM_STATE, BAT_NONE_STATE };

/** @brief class representing one single battery */
class Battery {
public:
	/** @brief constructor */
	Battery();

	/** @brief get the current state the battery is in
	 *
	 * @return the current battery state
	 */
	BATTERY_STATES batteryState() const;

	/** @brief update the battery state
	 *
	 * @return integer with current battery state
	 * @retval -1 on failure
	 * @retval 0 when state did not change
	 * @retval 1 when a lower battery level is reached
	 * @retval 2 when a higher battery level is reached
	 */
	int updateBatteryState(int ac_state, EventManagement *eM);

	/** @brief get the current charging state
	 *
	 * @return current charging state
	 */
	int chargingState() const;

	/** @brief get remaining time until battery is empty
	 *
	 * @return remaining time in minutes
	 */
	int remainingTime() const;

	/** @brief get remaining percentage until battery is empty
	 *
	 * @return remaining percent
	 */
	int remainingPercent() const;

	/** @brief return remaining time until battery is fully charged
	 *
	 * @return remaining charging time
	 */
	int remainingChargingTime() const;

	/** @brief reset the battery state to BAT_NORM state
	 *
	 * I'm not exactly sure whether this is needed
	 */
	void resetState();

private:
	/** @brief holds the current battery state */
	BATTERY_STATES _battery_state;

	/** @brief holds battery info for client requests */
	BatteryGeneral _bg;

	/** @brief sums up time since battery was last polled
	 *
	 * not private, because it needs to be reset on ACPI event from
	 * outside.
	 */
	unsigned _msecs_last_battery_read;
};

#endif // BATTERY_H
