/*
postman_flstring.c 
*/

 /*
* Program: Mail Delivery Module
*
* Author: Mark Crispin
* Networks and Distributed Computing
* Computing & Communications
* University of Washington
* Administration Building, AG-44
* Seattle, WA 98195
* Internet: MRC@CAC.Washington.EDU
*
* Date: 5 April 1993
* Last Edited: 2 September 2003
*
* The IMAP tools software provided in this Distribution is
* Copyright 2003 University of Washington.
* The full text of our legal notices is contained in the file called
* CPYRIGHT, included with this Distribution.
*/ /*
* Program: Mail Delivery Module
*
* Author: Mark Crispin
* Networks and Distributed Computing
* Computing & Communications
* University of Washington
* Administration Building, AG-44
* Seattle, WA 98195
* Internet: MRC@CAC.Washington.EDU
*
* Date: 5 April 1993
* Last Edited: 2 September 2003
*
* The IMAP tools software provided in this Distribution is
* Copyright 2003 University of Washington.
* The full text of our legal notices is contained in the file called
* CPYRIGHT, included with this Distribution.
*/

#include <stdio.h>
#include <pwd.h>
#include <errno.h>
extern int errno;
#include <sysexits.h>
#include <sys/file.h>
#include <sys/stat.h>
#include "mail.h"
#include "osdep.h"
#include "misc.h"
#include "linkage.h"

/* Globals */

char *version = "2003(12)"; /* dmail release version */
int debug = NIL; /* debugging (don't fork) */
int flagseen = NIL; /* flag message as seen */
int trycreate = NIL; /* flag saying gotta create before appending */
int critical = NIL; /* flag saying in critical code */
char *sender = NIL; /* message origin */

/* Function prototypes */

void file_string_init (STRING *s,void *data,unsigned long size);
char file_string_next (STRING *s);
void file_string_setpos (STRING *s,unsigned long i);
int main (int argc,char *argv[]);
int deliver (FILE *f,unsigned long msglen,char *user);
long ibxpath (MAILSTREAM *ds,char **mailbox,char *path);
int deliver_safely (MAILSTREAM *prt,STRING *st,char *mailbox,char *path,
char *tmp);
int delivery_unsafe (char *path,struct stat *sbuf,char *tmp);
int fail (char *string,int code);

/* File string driver for file stringstructs */

STRINGDRIVER postman_file_string = {
file_string_init, /* initialize string structure */
file_string_next, /* get next byte in string structure */
file_string_setpos /* set position in string structure */
};

/* Cache buffer for file stringstructs */

#define CHUNKLEN 16384
char chunk[CHUNKLEN];
/* Initialize file string structure for file stringstruct
* Accepts: string structure
* pointer to string
* size of string
*/

void file_string_init (STRING *s,void *data,unsigned long size)
  {
  s->data = data; /* note fd */
  s->size = size; /* note size */
  s->chunk = chunk;
  s->chunksize = (unsigned long) CHUNKLEN;
  SETPOS (s,0); /* set initial position */
  }

/* Get next character from file stringstruct
* Accepts: string structure
* Returns: character, string structure chunk refreshed
*/

char file_string_next (STRING *s)
  {
  char c = *s->curpos++; /* get next byte */
  SETPOS (s,GETPOS (s)); /* move to next chunk */
  return c; /* return the byte */
  }

/* Set string pointer position for file stringstruct
* Accepts: string structure
* new position
*/
void file_string_setpos (STRING *s,unsigned long i)
  {
  if (i > s->size) i = s->size; /* don't permit setting beyond EOF */
  s->offset = i; /* set new offset */
  s->curpos = s->chunk; /* reset position */
  /* set size of data */
  if (s->cursize = min (s->chunksize,SIZE (s))) 
    {
    /* move to that position in the file */
    fseek ((FILE *) s->data,s->offset,SEEK_SET);
    fread (s->curpos,sizeof (char),(unsigned int) s->cursize,(FILE *) s->data);
    }
  }

