/*
XSocket.h
*/

#ifndef __XSOCKET_H
#define __XSOCKET_H

#include        <stdio.h>
#include        <stdlib.h>
#include        <signal.h>
#include        <unistd.h>
#include        <errno.h>
#include        <fcntl.h>
#include        <string.h>
#include        <sys/types.h>
#include        <sys/un.h>
#include        <sys/socket.h>
#include        <netinet/in.h>
#include        <netdb.h>
#include        <arpa/inet.h>
#include        <strings.h>

#include "Config.h"

#define INVALID_SOCKET    -1
#define ERROR_SOCKET      -1
#define ERROR_SOCKET_PIPE -2

class XSocket
  {
  private:
    int wsock; 
    FILE *fsock;
  public:
    XSocket ();
    XSocket (int awsock);
    virtual ~XSocket ();
    void SetSock (int sock);
    void Close ();
    int getSock (void);
    int do_client_inet (char *host, char *service, int port, int timeout);
    int do_client_unix (char *filesocket);    
    int do_server_inet (int socket_type, u_short port, int *listener);
    int do_server_unix (int socket_type, int *listener);
    void do_server_unix_only_bind (int socket_type, int *listener, char *fn);
    bool Gets (char buf[], int nbytes);
    int Open (char *host, char *service, int port);
    int Puts (const char *buf);
    int Read (char *buf, int nbytes);
    int Write (const char *buf, int nbytes);
    char *Client_name (void);
    int atoport (char *service, char *proto);
    void ignore_pipe(void);
    //Send with timeout
    int Send_TO (const char* buf, int TimeoutSeconds);
  };

#include "Utils.h"
  
#endif
