/* vi:set ts=8 sts=8 sw=8:
 *
 * PMS  <<Practical Music Search>>
 * Copyright (C) 2006-2009  Kim Tore Jensen
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * topbar.h - topbar container class
 *
 */

#ifndef _PMS_ERROR_H_
#define _PMS_ERROR_H_

#include <string>

using namespace std;


typedef enum
{
	CERR_NONE = 0,
	CERR_NO_FILE,
	CERR_SYNTAX,
	CERR_UNKNOWN_COMMAND,
	CERR_EXCESS_ARGUMENTS,
	CERR_MISSING_IDENTIFIER,
	CERR_MISSING_VALUE,
	CERR_UNEXPECTED_TOKEN,
	CERR_INVALID_VALUE,
	CERR_INVALID_OPTION,
	CERR_INVALID_KEY,
	CERR_INVALID_COLOR,
	CERR_INVALID_COMMAND,
	CERR_INVALID_IDENTIFIER,
	CERR_INVALID_COLUMN,
	CERR_INVALID_TOPBAR_INDEX,
	CERR_INVALID_TOPBAR_POSITION
}
Cerror;

class Error
{
public:
				Error() { clear(); };
	void			clear() { code = 0; str.clear(); };

	int			code;
	string			str;
};


#endif /* _PMS_ERROR_H_ */
