# This file is released to the Public Domain by Moshe Zadka
# Author: Moshe Zadka <pms@zadka.site.co.il>
import ForwardingFolder, Log

class LimitFolder(ForwardingFolder.ForwardingFolder):

	def __init__(self, folder, func):
		Log.log("initializing LimitFolder")
		ForwardingFolder.ForwardingFolder.__init__(self)
		Log.log("setting up", folder, func)
		self._folder = folder
		self.func = func
		self.name = 'limit('+self._folder.name+')'
		self.index = 0

	def _get_messages(self):
		Log.log("getting messages")
		messages = []
		for mes in self._folder.messages:
			Log.log("checking", mes)
			if self.func(self._folder, mes):
				Log.log("added", mes)
				messages.append(mes)
		Log.log("got", len(messages))
		return messages

	def folder(self, folder):
		Log.log("getting subfolder", folder)
		return LimitFolder(self._folder.folder(folder), self.func)
