# This file is released to the Public Domain by Moshe Zadka
# Author: Moshe Zadka <pmh@zadka.site.co.il>
import Actions, Commands, tempfile, os, rfc822, popen2, string, base64
from cStringIO import StringIO

def _get_uids(mess):
	recipients = []
	for header in ('to', 'cc', 'bcc'):
		addresses = rfc822.AddrlistClass(mess.get(header, '')).getaddrlist()
		for address in addresses:
			recipients.append(rfc822.dump_address_pair(address))
	return recipients

def _filter_message(uid, mess, command):
	name = tempfile.mktemp()
	fp = open(name, 'w')
	try:
		fp.write(mess.fp.read())
	finally:
		fp.close()
	name2 = tempfile.mktemp()
	os.system("%s < %s > %s" % (command, name, name2))
	mess.fp = open(name2)
	Actions.save_draft(mess, uid)
	return 1

def gpg_sign(uid):
	mess = Actions.get_draft(uid)
	_filter_message(uid, mess, 'gpg --clearsign')
	return 1
Commands.edit_actions['sign'] = gpg_sign

def gpg_encrypt(uid):
	mess = Actions.get_draft(uid)
	recipients = _get_uids(mess)
	_filter_message(uid, mess, 'gpg --armor --encrypt')
	return 1
# Currently no UI

def gpg_sign_encrypt(uid):
	mess = Actions.get_draft(uid)
	recipients = _get_uids(mess)
	_filter_message('gpg --armor --encrypt --clearsign')
	return 1
Commands.edit_actions['encrypt'] = gpg_encrypt

def gpg_header_sign(uid):
	mess = Actions.get_draft(uid)
	body = mess.fp.read()
	rp, wp = popen2.popen2('gpg --detach-sign')
	wp.write(body)
	wp.close()
	sig = rp.read()
	sig = string.split(base64.encodestring(sig))
	sig = string.join(sig, '')
	mess['x-pgp-signature'] = sig
	mess.fp = StringIO(body)
	Actions.save_draft(mess, uid)
	return 1
Commands.edit_actions['header-sign'] = gpg_header_sign
