# This file is released to the Public Domain by Moshe Zadka
# Author: Moshe Zadka <pms@zadka.site.co.il>
import AbstractFolder, Log

class ForwardingFolder(AbstractFolder.AbstractFolder):

	def __init__(self):
		Log.log("initializing ForwardingFolder")
		AbstractFolder.AbstractFolder.__init__(self)

	def get_header(self, index=None):
		Log.log("getting headers of", index)
		return self._folder.get_header(self.get_uid(index))

	def get_message(self, index=None):
		Log.log("getting message", index)
		return self._folder.get_message(self.get_uid(index))

	def _get_folders(self):
		Log.log("getting folders")
		return self._folder.folders

	def _remove_message(self, message):
		Log.log("removing", message)
		self._folder.remove_message(message)

	def save_message(self, message, index=None):
		Log.log("saving message to", index)
		uid = self._folder.save_message(message, index)
		Log.log("saved to", uid)
		del self.messages
		return uid

	def create(self):
		Log.log("creating father")
		self._folder.create()

        def resync(self):
                Log.log("resyncing folder")
                self._folder.resync()
                AbstractFolder.AbstractFolder.resync(self)
