# This file is released to the Public Domain by Moshe Zadka
# Author: Moshe Zadka <pms@zadka.site.co.il>
import Configuration, Servers, Runner, Actions, MailMessage, AbstractFolder
import os, string, tempfile, sys, re, errno
from cStringIO import StringIO

EDITOR = "/usr/bin/editor"
PAGER = "/usr/bin/pager"

class edit_draft:

	args = []

	def __call__(self, runner, uid):
		config = Configuration.Configuration()
		editor = (config.config.get('edit_draft', {}).get("editor") or 
		          os.environ.get("VISUAL") or 
		          os.environ.get("EDITOR") or 
		          EDITOR)
		tmpfile = tempfile.mktemp()
		fp = open(tmpfile, 'w')
		try:
			try:
				os.chmod(tmpfile, 0600)
				message = Actions.get_draft(uid)
				Actions.serialize_message(message, fp)
			finally:
				fp.close()
			os.system(editor+" "+tmpfile)
			fp = open(tmpfile)
			try:
				message = MailMessage.parse(fp)
				Actions.save_draft(message, uid)
			finally:
				fp.close()
		finally:
			os.unlink(tmpfile)

Runner.Runner().register('edit_draft', edit_draft())

class show:

	args = ['full_headers', 'headers_only']

	def __call__(self, runner, full_headers=0, headers_only=0):
		config = Configuration.Configuration()
		folder = config.status.get_folder()
		if headers_only:
			self.message = folder.get_headers()
		else:
			self.message = folder.get_message()
		self.get_fp()
		try:
			try:
				if full_headers:
					self.full_headers()
				else:
					self.needed_headers()
				self.write_body()
			finally:
				self.close_fp()
		except IOError, err:
			if err.errno != errno.EPIPE:
				raise

	def write_body(self):
		self.fp.write('\n')
		while 1:
			buf = self.message.fp.read(4096)
			if not buf:
				break
			self.fp.write(buf)

	def get_fp(self):
		config = Configuration.Configuration()
		pager = (config.config.get('show', {}).get('pager') 
		         or os.environ.get('PAGER')
		         or PAGER)
		if sys.stdout.isatty():
			self.fp = os.popen(pager, 'w')
		else:
			self.fp = sys.stdout

	def close_fp(self):
		if self.fp is not sys.stdout:
			self.fp.close()
		
	def _write_header(self, key, value):
			key = MailMessage.capitalize_header(key)
			self.fp.write('%s: %s\n' % (key, value))

	def full_headers(self):
		for (key, value) in self.message.items():
			self._write_header(key, value)

	def needed_headers(self):
		config = Configuration.Configuration()
		headers = 'from to cc date subject'
		headers = config.config.get('show', {}).get('headers', headers)
		headers = string.split(headers)
		for header in headers:
			try:
				content = self.message[header]
			except KeyError:
				pass
			else:
				self._write_header(header, content)

Runner.Runner().register('show', show())

class prompt:

	args = []

	def __call__(self, runner, question, answers):
		print question
		while 1:
			print string.join(answers, ', ')
			answer = raw_input('? ')
			possible = get_begins_with(answer, answers)
			if len(possible) == 1:
				return possible[0]

Runner.Runner().register('prompt', prompt())

class scan:

	args = ['folder_only', 'recursive', 'summary']

	def __call__(self, runner, folder_only=0, recursive=0, summary=0):
		folder = Configuration.Configuration().status.get_folder()
		try:
			self._scan(folder, folder_only, recursive, summary)
		except IOError, err:
			if err.errno != errno.EPIPE:
				raise

	def _scan(self, folder, folder_only, recursive, summary):
		messages = folder.messages
		if messages:
			self._print_messages(messages, folder,
			                     folder_only, summary)
		if recursive:
			for subfolder in folder.folders:
				sub = folder.folder(subfolder)
				self._scan(sub, folder_only, recursive, summary)

	def _print_messages(self, messages, folder, folder_only, summary):
		print folder.name, '(%s)' % len(messages)
		if folder_only and not summary:
			return
		summ = {}
		summs = []
		for i in range(len(messages)):
			m = messages[i]
			mes = folder.get_header(m)
			subject = mes.get('subject', 'no subject')
			from_ = mes.get('from', 'unidentified sender')
			if len(from_)>10:
				from_ = from_[:7]+'...'
			if len(subject)>63:
				subject = subject[:60]+'...'
			if not folder_only and not summary:
				print i, subject, '('+from_+')'
			if summary:
				ssub = string.lower(string.strip(subject))
				while ssub[:3]=='re:':
					ssub = string.strip(ssub[3:])
				if summ.has_key(ssub):
					summ[ssub] = summ[ssub]+1
				else:
					summs.append((ssub,subject))
					summ[ssub] = 1
		if summary:
			print "%d topics" % len(summs)
			if not folder_only:
				for k,s in summs:
					print "%4d %s" % (summ[k], s)

Runner.Runner().register('scan', scan())


def help(action, more=0):
	args = map(lambda x: '[-%s]' % x, Runner.Runner().get_args(action))
	usage = 'usage: %(name)s '+string.join(args)
	if type(more) == type(()):
		return usage+(" name"*more[0])+(" [name]"*(more[1]-more[0]))
	else:
		return usage+(" name"*more)

def parse_arguments(action, args):
	return parse_arguments_extra(action, args, 0)[0]

def get_begins_with(prefix, list):
	possible = []
	for possibility in list:
		if possibility[:len(prefix)]==prefix:
			possible.append(possibility)
	return possible

def parse_arguments_extra(action, args, more):
	d = {}
	valid = Runner.Runner().get_args(action)
	while args:
		if args[0][0] != '-':
			break
		arg = get_begins_with(args.pop(0)[1:], valid)
		if len(arg) != 1:
			raise RuntimeError(help(action, more))
		d[arg[0]] = 1
	if (type(more) == type(()) and not (more[0]<=len(args)<=more[1])) or \
	   (type(more) != type(()) and len(args) != more):
		raise RuntimeError(help(action))
	return d, args

_num = re.compile('[0-9]+$')
_num_pair = re.compile('([0-9]+)-([0-9]+)$')

class BadArgumentError(ValueError):
	pass

def parse_number_list(args):
	nums = []
	for arg in args:
		for part in string.split(arg, ','):
			if _num.match(part):
				nums.append(int(part))
				continue
			m = _num_pair.match(arg)
			if m:
				min, max = map(int, m.groups())
				nums.extend(range(min, max+1)) 
				continue
			raise BadArgumentError(part+ " not a number list")
	return nums

import sys, Servers
def run_function(f, args, kw):
	try:
		apply(f, args, kw)
	except NotImplementedError, s:
		raise RuntimeError("unsupported action for "
		                   "folder/server: "+s[0])
	except AbstractFolder.NoSuchMessageError, s:
		raise RuntimeError(str(s))
	except BadArgumentError, s:
		raise RuntimeError(str(s))
	except Servers.ServerNotFound, e:
		if e.args[0] is None:
			raise RuntimeError("no default server")
		raise RuntimeError("no such server: "+e.args[0])
	except KeyboardInterrupt:
		pass

