# This file is released to the Public Domain by Moshe Zadka
# Author: Moshe Zadka <pms@zadka.site.co.il>
import Folder, Configuration, Runner, Servers, MailMessage, Log
import Actions, RecursiveFolder
from Limits import limit_subject, limit_from, limit_replies, limit_label
from Sorts import sort_from, sort_subject, sort_date

def plus(how_much=1):
	'''\
	plus(how_much=1) 

	Advance to the next messages (or [how_much] messages)
	'''
	Log.log("advancing", how_much, "messages")
	for i in range(how_much):
		Log.log("-->advancing a message")
		Configuration.Configuration().status.next_message()

def minus(how_much=1):
	'''\
	minus(how_much=1) 

	Go to the previous messages (or [how_much] messages)
	'''
	Log.log("going back", how_much, "messages")
	for i in range(how_much):
		Log.log("-->going back a message")
		Configuration.Configuration().status.prev_message()

def index(i):
	'''\
	index(i)

	Go to message number [i]
	'''
	Log.log("selecting message", i)
	Configuration.Configuration().status.index_message(i)

def folder(name, **kw):
	'''\
	folder(name, opt=value...)

	Change to another folder
	'''
	Log.log("going to folder", folder, "with options", kw)
	apply(Runner.Runner().folder, (name,), kw)

def server(name, folder='inbox'):
	'''\
	server(name)

	Change the default server
	'''
	Log.log("changing to server", name, "with default folder", folder)
	Configuration.Configuration().status.set_server(name, folder)

edit_actions = {}

def _send(uid):
	Log.log("sending draft", uid)
	Runner.Runner().send(uid)
	return 0
edit_actions['send'] = _send

def _save_draft(uid):
	Log.log("saving draft", uid)
	return 0
edit_actions['save draft'] = _save_draft

def _delete(uid):
	Log.log("removing draft", uid)
	Actions.remove_draft(uid)
	return 0
edit_actions['delete'] = _delete

def _edit(uid):
	Log.log("continue to edit draft", uid)
	return 1
edit_actions['edit'] = _edit

def _edit_send_delete(uid):
	Log.log("editing", uid)
	while 1:
		Log.log("running editor")
		Runner.Runner().edit_draft(uid)
		question = "What now?"
		answers = edit_actions.keys()
		answer = Runner.Runner().prompt(question, answers)
		Log.log("action", answer)
		if not edit_actions[answer](uid):
			Log.log("finished with", answer)
			break

def edit(index):
	'''\
	edit(index)

	Edit [index] draft
	'''
	Log.log("editing existing draft number", index)
	draft = Configuration.Configuration().special('draft')
	uid = draft.messages[index]
	_edit_send_delete(uid)


def comp(**kw):
	'''\
	comp(opt=value, ...)

	Compose a new message
	'''
	Log.log("composing a new message", kw)
	_edit_send_delete(apply(Runner.Runner().new, (), kw))

def repl(**kw):
	'''\
	repl(opt=value, ...)

	Reply to current message
	'''
	Log.log("replying to current message", kw)
	_edit_send_delete(apply(Runner.Runner().new_reply, (), kw))

def forward(**kw):
	'''\
	forward(opt=value, ...)

	Forward current message
	'''
	Log.log("forwarding current message", kw)
	_edit_send_delete(apply(Runner.Runner().new_forward, (), kw))

def show(**kw):
	'''\
	show(opt=value, ...)

	Show current message
	'''
	Log.log("showing current message", kw)
	apply(Runner.Runner().show, (), kw)

def scan(**kw):
	'''\
	scan(opt=value, ...)

	Scan messages in current folder
	'''
	Log.log("scanning current folder", kw)
	apply(Runner.Runner().scan, (), kw)

def _calc_messages(messages):
	Log.log("getting uids for", messages)
	status = Configuration.Configuration().status
	if not messages:
		Log.log("no messages, getting current uid")
		return [status.get_folder().get_uid()]
	else:
		Log.log("appending uids")
		ret = []
		for message in messages:
			Log.log("appending for message", message)
			ret.append(status.get_folder().messages[message])
		return ret

def subset(messages):
	'''\
	subset(messages)

	Push a folder with only the messages with given indices
	'''
	Log.log("moving to a subset with", messages)
	status = Configuration.Configuration().status
	from SubsetFolder import SubsetFolder 
	folder = status.get_folder()
	Log.log("got folder", folder)
	new_folder = SubsetFolder(folder, messages)
	Log.log("created new folder", folder)
	status.push_folder(new_folder)
	Log.log("pushed new folder")

def remove(messages):
	'''\
	remove(messages)

	Remove the messages with the given indices from the current folder
	'''
	Log.log("removing", messages)
	status = Configuration.Configuration().status
	for message in _calc_messages(messages):
		Log.log("removing", message)
		status.remove_message(message)

def refile(folder, messages, server=None, keep_orig=0):
	'''\
	refile(folder, messages, [server, [keep_orig]])

	Refile messages with given indices in another folder.
	If [server] is given, it should be a name of a server.
	If [keep_orig] is false (default), messages are deleted
	from original folder.
	'''
	Log.log("refiling", messages, "to", folder, server, 
	        "keep_orig=", keep_orig)
	status = Configuration.Configuration().status
	in_folder = status.get_folder()
	if server is None:
		server = status.server
		Log.log("using server", server)
	out_folder = Folder.Folder(server, folder)
	for uid in _calc_messages(messages):
		Log.log("saving", uid)
		message = in_folder.get_message(uid)
		Log.log("got message")
		out_folder.save_message(message)
		Log.log("saving message")
		if not keep_orig:
			Log.log("removing message")
			status.remove_message(uid)

def label(text, messages):
	'''\
	label(text, messages)

	Label messages with given indices with [text]
	'''
	from cStringIO import StringIO
	folder = Configuration.Configuration().status.get_folder()
	Log.log("labaling", messages, "with", `text`)
	for uid in _calc_messages(messages):
		Log.log("labeling", uid)
		message = folder.get_message(uid)
		Log.log("got message")
		message['X-PMS-Label'] = text
		message.fp = StringIO(message.fp.read())
		Log.log("saving message")
		folder.save_message(message, uid)

def pop():
	'''\
	pop()

	Pop the current folder
	'''
	Log.log("popping current folder")
	Configuration.Configuration().status.pop_folder()

def recursive():
	'''\
	recursive()

	Push a folder which contains all messages in current
	folder and in all decendants
	'''
	Log.log("getting recursive folder")
	status = Configuration.Configuration().status
	folder = status.get_folder()
	Log.log("got folder", folder)
        recursive = RecursiveFolder.RecursiveFolder(folder)
	Log.log("got recursive folder", recursive)
        status.push_folder(recursive)
	Log.log("pushed folder")

def create():
	'''\
	create()

	Cause the current folder to exist
	'''
	status = Configuration.Configuration().status
	Log.log("creating folder")
	status.get_folder().create()
