# +-----------------------------------------------------------------------+
# | pLoader - a Perl photo uploader for Piwigo                            |
# +-----------------------------------------------------------------------+
# | Copyright(C) 2008-2010 Piwigo Team                  http://piwigo.org |
# +-----------------------------------------------------------------------+
# | This program is free software; you can redistribute it and/or modify  |
# | it under the terms of the GNU General Public License as published by  |
# | the Free Software Foundation                                          |
# |                                                                       |
# | This program is distributed in the hope that it will be useful, but   |
# | WITHOUT ANY WARRANTY; without even the implied warranty of            |
# | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU      |
# | General Public License for more details.                              |
# |                                                                       |
# | You should have received a copy of the GNU General Public License     |
# | along with this program; if not, write to the Free Software           |
# | Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, |
# | USA.                                                                  |
# +-----------------------------------------------------------------------+
package Uploader::GUI::wxPropertyListDlg;
use strict;
use Wx qw/
             wxDefaultSize
             wxDefaultPosition
             wxLIST_AUTOSIZE
             wxDEFAULT_DIALOG_STYLE
             wxMAXIMIZE_BOX
             wxMINIMIZE_BOX
             wxLC_NO_HEADER
         /;
use Wx::Locale qw/:default/;
use base qw/Wx::Dialog Uploader::Object2/;

use Data::Dumper;
__PACKAGE__->mk_accessors(     
    qw/
        properties
        list
      /
);



sub new {
    my ($this, $params) = @_;
    #on recupere le nom de la classe en fonction du type d'appel de la mthode.
    my $class = ref($this) || $this;


    my $self = $class->SUPER::new( 
        undef,
        -1,
        $params->{caption}, 
        wxDefaultPosition, 
        wxDefaultSize, 
        wxDEFAULT_DIALOG_STYLE|
        wxMAXIMIZE_BOX|
        wxMINIMIZE_BOX
    );

    &main::image_prop_exif($self);

    $self->properties(
        $params->{properties}
    );
    $self->list(
        $self->FindWindow($main::IMG_PROP_EXIF_LIST)
    );

    $self->list->SetSingleStyle(wxLC_NO_HEADER);

    $self->{img_exif_prop_close} = $self->FindWindow($main::IMG_PROP_EXIF_CLOSE);

    $self->{img_exif_prop_close}->SetLabel(
        gettext("Close")
    );

    Wx::Event::EVT_BUTTON( $self, $self->{img_exif_prop_close}, \&OnClose );

    $self->list->InsertColumn(0, gettext("Property"));
    $self->list->InsertColumn(1, gettext("Value"));
    
    $self;
}


sub Refresh {
    my ( $self ) = @_;

    $self->list->Freeze;
    $self->list->DeleteAllItems;
    my $i=0;
    map {
        $self->list->InsertStringItem($i, $_->{label});
        $self->list->SetItem($i, 1, $_->{value}->());
        $i++;
    }@{$self->properties};
    $self->list->SetColumnWidth(0, wxLIST_AUTOSIZE );
    $self->list->SetColumnWidth(1, wxLIST_AUTOSIZE );
    $self->list->Thaw;
}

# call to destroy crashes with GTK
sub OnClose {
    my ( $self, $event ) = @_;
    
    $self->Hide;
}

1;