/*
 *  Player - One Hell of a Robot Server
 *  Copyright (C) 2000
 *     Brian Gerkey, Kasper Stoy, Richard Vaughan, & Andrew Howard
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
 * robot_params.h
 *
 * ActivMedia robot parameters, automatically generated by saphconv.tcl from
 * Saphira parameter files:
 *    amigo.p
 *    amigo-sh.p
 *    p2at.p
 *    p2at8+.p
 *    p2at8.p
 *    p2ce.p
 *    p2d8+.p
 *    p2d8.p
 *    p2de.p
 *    p2df.p
 *    p2dx.p
 *    p2it.p
 *    p2pb.p
 *    p2pp.p
 *    p3at-sh.p
 *    p3at.p
 *    p3atiw.p
 *    p3dx-sh.p
 *    p3dx.p
 *    peoplebot-sh.p
 *    perfpb+.p
 *    perfpb.p
 *    pion1m.p
 *    pion1x.p
 *    pionat.p
 *    powerbot-sh.p
 *    powerbot.p
 *    psos1m.p
 *    psos1x.p
*/

#ifndef _ROBOT_PARAMS_H
#define _ROBOT_PARAMS_H


void initialize_robot_params(void);

#define PLAYER_NUM_ROBOT_TYPES 29


typedef struct
{
  double x;
  double y;
  double th;
  double length;
  double radius;
} bumper_def_t;

typedef struct
{
  double x;
  double y;
  double th;
} sonar_pose_t;


typedef struct
{
  double AngleConvFactor; //
  char* Class;
  double DiffConvFactor; //
  double DistConvFactor; //
  int FrontBumpers; //
  double GyroScaler; //
  int HasMoveCommand; //
  int Holonomic; //
  int IRNum; //
  int IRUnit; //
  int LaserFlipped; //
  char* LaserIgnore;
  char* LaserPort;
  int LaserPossessed; //
  int LaserPowerControlled; //
  int LaserTh; //
  int LaserX; //
  int LaserY; //
  int MaxRVelocity; //
  int MaxVelocity; //
  int NewTableSensingIR; //
  int NumFrontBumpers; //
  int NumRearBumpers; //
  double RangeConvFactor; //
  int RearBumpers; //
  int RequestEncoderPackets; //
  int RequestIOPackets; //
  int RobotDiagonal; //
  int RobotLength; //
  int RobotRadius; //
  int RobotWidth; //
  int RotAccel; //
  int RotDecel; //
  int RotVelMax; //
  int SettableAccsDecs; //
  int SettableVelMaxes; //
  int SonarNum; //
  char* Subclass;
  int SwitchToBaudRate; //
  int TableSensingIR; //
  int TransAccel; //
  int TransDecel; //
  int TransVelMax; //
  int Vel2Divisor; //
  double VelConvFactor; //
  sonar_pose_t sonar_pose[32];
  bumper_def_t bumper_geom[32];
} RobotParams_t;


extern RobotParams_t PlayerRobotParams[];


#endif
