/*
 *  Player - One Hell of a Robot Server
 *  Copyright (C) 2000  
 *     Brian Gerkey, Kasper Stoy, Richard Vaughan, & Andrew Howard
 *                      
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
 * $Id: playertime.h,v 1.2 2005/08/08 03:53:21 gerkey Exp $
 *
 * this is the base class for the WallclockTime and StageTime classes.
 *
 */
#ifndef _PLAYERTIME_H
#define _PLAYERTIME_H

#include <sys/time.h>

class PlayerTime
{
  public:
    // fills in the timeval struct with the current time, from the right
    // source.
    //
    // returns 0 on success, -1 on error    
    virtual int GetTime(struct timeval* time) = 0;
    virtual int GetTimeDouble(double* time) = 0;
    virtual ~PlayerTime() {};
};


/* never worry about timersub type activies again -- from GLIBC and upcased. */
#define TIMESUB(a, b, result)                                                 \
  do {                                                                        \
    (result)->tv_sec = (a)->tv_sec - (b)->tv_sec;                             \
    (result)->tv_usec = (a)->tv_usec - (b)->tv_usec;                          \
    if ((result)->tv_usec < 0) {                                              \
      --(result)->tv_sec;                                                     \
      (result)->tv_usec += 1000000;                                           \
    }                                                                         \
  } while (0)

#endif
