/*
 * You know what I hate about Linux? They randomly and for no good reason
 * change things that were standardized a long time ago. Someone feels that
 * S_IFDIR or ifconfig or /var/cron or libc.so could use a facelift and the
 * next version breaks all scripts and programs written for last week's
 * "standard". I normally like Linux, but I wish someone with experience
 * in software and version management would take charge.
 *
 * This file exists because Linux once again has scrambled essential files,
 * this time in /usr/include. All the S_IF* macros either disappeared or
 * moved into brand-new files such as statbuf.h, which no other Unix or
 * even the previous version of Linux has ever heard of. No wonder there
 * are so few commercial applications, this is an impossible situation in
 * a professional environment. No doubt the next Linux version will reverse
 * the bit order or something. Please people, it's frighteningly easy to
 * kill a good project with poor planning.
 */

#ifdef S_ISDIR
#define IS_DIR(m) S_ISDIR(m)
#else
#ifdef S_IFDIR
#define IS_DIR(m) ((m) & S_IFDIR)
#else
#define IS_DIR(m) ((m) & 040000)
#endif
#endif

#ifndef S_IFLNK			/* this is, of course, the kind of bad code */
#define S_IFLNK 0120000		/* that standard headers were supposed to */
#endif				/* avoid. */

#ifndef S_IFMT
#define S_IFMT  0170000
#endif

#ifndef S_IFCHR
#define S_IFCHR 0020000
#endif
