/* Generated from "Stylesheet.cmod" by precompile.pike
 *
 * Do NOT edit this file.
 */

#undef PRECOMPILE_API_VERSION
#define PRECOMPILE_API_VERSION 2


#line 1 "Stylesheet.cmod"
/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: Stylesheet.cmod,v 1.20 2005/10/18 22:55:28 hww3 Exp $
 */

/*
 * File licensing and authorship information block.
 *
 * Version: MPL 1.1/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Initial Developer of the Original Code is
 *
 * Bill Welliver <hww3@riverweb.com>
 *
 * Portions created by the Initial Developer are Copyright (C) Bill Welliver
 * All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of the LGPL, and not to allow others to use your version
 * of this file under the terms of the MPL, indicate your decision by
 * deleting the provisions above and replace them with the notice
 * and other provisions required by the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL or the LGPL.
 *
 * Significant Contributors to this file are:
 *
 *
 */

#define THIS_IS_XML2_STYLESHEET 1

#include "xml2.h"

/*! @module Public
 */

/*! @module Parser
 */

/*! @module XML2
 */

/*! @class Stylesheet
 */


#undef class_Stylesheet_defined
#define class_Stylesheet_defined
struct program *Stylesheet_program=NULL;
static int Stylesheet_program_fun_num=-1;

#undef var_object_data_Stylesheet_defined
#define var_object_data_Stylesheet_defined

#undef var_node_Stylesheet_defined
#define var_node_Stylesheet_defined

#undef var_docloader_Stylesheet_defined
#define var_docloader_Stylesheet_defined

#undef THIS
#define THIS ((struct Stylesheet_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_STYLESHEET
#define THIS_STYLESHEET ((struct Stylesheet_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_STYLESHEET
#define OBJ2_STYLESHEET(o) ((struct Stylesheet_struct *)(o->storage+Stylesheet_storage_offset))

#undef GET_STYLESHEET_STORAGE
#define GET_STYLESHEET_STORAGE ((struct Stylesheet_struct *)(o->storage+Stylesheet_storage_offset)
static ptrdiff_t Stylesheet_storage_offset;
struct Stylesheet_struct {

#ifdef var_object_data_Stylesheet_defined
#line 80 "Stylesheet.cmod"
STYLESHEET_OBJECT_DATA   *object_data;
#endif /* var_object_data_Stylesheet_defined */

#ifdef var_node_Stylesheet_defined
  struct object * node;

#endif /* var_node_Stylesheet_defined */

#ifdef var_docloader_Stylesheet_defined
  struct svalue docloader;

#endif /* var_docloader_Stylesheet_defined */
};
#line 86 "Stylesheet.cmod"
void my_xsltGenericErrorFunc(void * ctx, const char *msg, ...)
  {
    va_list args;

    va_start(args,msg);
    vprintf(msg, args);
    va_end(args);
  }

/*! @decl void set_docloader(function f)
 *!
 *! sets the xslt loader function. this is local to the stylesheet.
 *!
 *! the callout should have the following signature:
 *!
 *!  Node f(string uri, int options, int type)
 *!
 *!  where:
 *!    uri is the URI of the document to load
 *!    options are a set of xmlParserOption
 *!    the xsltLoadType indicating the kind of loading required
 */
#define f_Stylesheet_set_docloader_defined
ptrdiff_t f_Stylesheet_set_docloader_fun_num = 0;
void f_Stylesheet_set_docloader(INT32 args) {
#line 108 "Stylesheet.cmod"
struct svalue * f;
#line 108 "Stylesheet.cmod"
if(args != 1) wrong_number_of_args_error("set_docloader",args,1);
#line 108 "Stylesheet.cmod"
if(Pike_sp[0-1].type != PIKE_T_FUNCTION) SIMPLE_BAD_ARG_ERROR("set_docloader",1,"function");
#line 108 "Stylesheet.cmod"
f=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
{
  /* TODO: we probably have a memory leak here... */
  assign_svalue(&(THIS->docloader), f);
#ifdef HAVE_XSLTSETLOADERFUNC
#else
  Pike_error("set_docloader not available. upgrade your libxslt.\n");
#endif
  pop_stack();
}

}
/*! @decl void clear_docloader()
 *!
 *! clears the stylesheet docloader callout, if one was set.
 *!
 */
#define f_Stylesheet_clear_xslt_docloader_defined
ptrdiff_t f_Stylesheet_clear_xslt_docloader_fun_num = 0;
void f_Stylesheet_clear_xslt_docloader(INT32 args) {
#line 124 "Stylesheet.cmod"
if(args != 0) wrong_number_of_args_error("clear_xslt_docloader",args,0);
{

  /* TODO: we probably have a memory leak here... */
  push_int(0);
  assign_svalue(&(THIS->docloader), Pike_sp-1);
#ifdef HAVE_XSLTSETLOADERFUNC
#else
  Pike_error("set_docloader not available. upgrade your libxslt.\n");
#endif
}

  
}
#line 137 "Stylesheet.cmod"
/* 

   The pike - docloader callback glue
  
 */
xmlDocPtr pike_docloader_conv (const xmlChar * URI, xmlDictPtr dict, 
                               int options, void * ctxt, int type)
{
    struct Node_struct * ns;
    NODE_OBJECT_DATA * od;
    struct object * xnode;
printf("docloader()\n");
    stack_dup();
    push_text(URI);
    push_int(options);
    push_int(type);
    apply_svalue(&Pike_sp[0-4], 3);

    if(Pike_sp[0-1].type != T_OBJECT)
      return NULL;

    CHECK_NODE_PASSED(Pike_sp[0-1].u.object);
    add_ref(Pike_sp[0-1].u.object);
    ns = OBJ2_NODE(Pike_sp[0-1].u.object);
    od = (NODE_OBJECT_DATA *)(ns->object_data);

    pop_stack();

    if(od->node->doc == NULL)
      return NULL;    
    else return od->node->doc;

    return NULL;
}

#define f_Stylesheet_cq__sprintf_defined
ptrdiff_t f_Stylesheet_cq__sprintf_fun_num = 0;
void f_Stylesheet_cq__sprintf(INT32 args) {
#line 172 "Stylesheet.cmod"
INT_TYPE type;
#line 172 "Stylesheet.cmod"
struct svalue * t;
#line 172 "Stylesheet.cmod"
if(args != 2) wrong_number_of_args_error("_sprintf",args,2);
#line 172 "Stylesheet.cmod"
if(Pike_sp[0-2].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("_sprintf",1,"int");
type=Pike_sp[0-2].u.integer;
#line 172 "Stylesheet.cmod"
t=Pike_sp+1-2; dmalloc_touch_svalue(Pike_sp+1-2);
{
  char * desc;

  check_stylesheet_created();
  
  push_text("Stylesheet()");
}

}
#define f_Stylesheet_create_defined
ptrdiff_t f_Stylesheet_create_fun_num = 0;
void f_Stylesheet_create(INT32 args) {
#line 181 "Stylesheet.cmod"
if(args != 0) wrong_number_of_args_error("create",args,0);
{
}

}
/*! @decl Node apply(Node xml, mapping|void attributes)
 *!
 *! apply the stylesheet object to an xml file.
 *!
 *! @param xml
 *!   a @[Node] object from the parsed XML document to apply.
 *!   Any node from the XML document may be used.
 *!
 *! @param attributes
 *!   an optional mapping of attributes. If supplied, this parameter
 *!   will override any set with @[set_attributes()].
 *!
 *! @returns
 *!    a @[Node] object for the transformed document.
 */
#define f_Stylesheet_apply_1_defined
ptrdiff_t f_Stylesheet_apply_1_fun_num = 0;
void f_Stylesheet_apply_1(INT32 args) {
#line 200 "Stylesheet.cmod"
struct object * xml;
#line 200 "Stylesheet.cmod"
if(args != 1) wrong_number_of_args_error("apply",args,1);
#line 200 "Stylesheet.cmod"
if(Pike_sp[0-1].type != PIKE_T_OBJECT) SIMPLE_BAD_ARG_ERROR("apply",1,"object");
#line 200 "Stylesheet.cmod"
debug_malloc_pass(xml=Pike_sp[0-1].u.object);
{
  CHECK_NODE_PASSED(xml);

  low_apply_stylesheet(args, xml, THIS->object_data->atts);
}

}
/*! @decl string output_type()
*/
#define f_Stylesheet_output_type_defined
ptrdiff_t f_Stylesheet_output_type_fun_num = 0;
void f_Stylesheet_output_type(INT32 args) {
#line 209 "Stylesheet.cmod"
if(args != 0) wrong_number_of_args_error("output_type",args,0);
{
  if(THIS->object_data->stylesheet == NULL)
    push_int(0);
  else 
  {
    if(THIS->object_data->stylesheet->method != NULL)
      push_text(THIS->object_data->stylesheet->method);
    else
      push_text("xml");
  }
}

}
/*! @decl string media_type()
*/
#define f_Stylesheet_media_type_defined
ptrdiff_t f_Stylesheet_media_type_fun_num = 0;
void f_Stylesheet_media_type(INT32 args) {
#line 224 "Stylesheet.cmod"
if(args != 0) wrong_number_of_args_error("media_type",args,0);
{
  if(THIS->object_data->stylesheet == NULL)
    push_int(0);
  else 
  {
    if(THIS->object_data->stylesheet->mediaType != NULL)
      push_text(THIS->object_data->stylesheet->mediaType);
    else
      push_int(0);
  }
}

}
#define f_Stylesheet_apply_2_defined
ptrdiff_t f_Stylesheet_apply_2_fun_num = 0;
void f_Stylesheet_apply_2(INT32 args) {
#line 237 "Stylesheet.cmod"
struct object * xml;
#line 237 "Stylesheet.cmod"
struct mapping * attributes;
#line 237 "Stylesheet.cmod"
if(args != 2) wrong_number_of_args_error("apply",args,2);
#line 237 "Stylesheet.cmod"
if(Pike_sp[0-2].type != PIKE_T_OBJECT) SIMPLE_BAD_ARG_ERROR("apply",1,"object");
#line 237 "Stylesheet.cmod"
debug_malloc_pass(xml=Pike_sp[0-2].u.object);
#line 237 "Stylesheet.cmod"
if(Pike_sp[1-2].type != PIKE_T_MAPPING) SIMPLE_BAD_ARG_ERROR("apply",2,"mapping(mixed:mixed)");
#line 237 "Stylesheet.cmod"
debug_malloc_pass(attributes=Pike_sp[1-2].u.mapping);
{

  char** vars = NULL;
  int i = 0;

  CHECK_NODE_PASSED(xml);

  vars = low_set_attributes(attributes);

  low_apply_stylesheet(args, xml, (const char **)vars);
}

}

#if defined(f_Stylesheet_apply_1_defined) || defined(f_Stylesheet_apply_2_defined)
#define f_Stylesheet_apply_defined
ptrdiff_t Stylesheet_f_Stylesheet_apply_fun_num = 0;
void f_Stylesheet_apply(INT32 args) {
  switch(args) {
   case 1:

#ifdef f_Stylesheet_apply_1_defined
    f_Stylesheet_apply_1(args);
    return;

#endif /* f_Stylesheet_apply_1_defined */
    break;
   case 2:

#ifdef f_Stylesheet_apply_2_defined
    f_Stylesheet_apply_2(args);
    return;

#endif /* f_Stylesheet_apply_2_defined */
    break;
   default:
    wrong_number_of_args_error("apply",args,1);
  }
}

#endif /* f_Stylesheet_apply_1_defined, f_Stylesheet_apply_2_defined */
#line 250 "Stylesheet.cmod"
void low_apply_stylesheet(INT32 args, struct object * xml, const char ** atts)
{
  int i;
  xmlDocPtr output;
  struct Node_struct * ns;
  NODE_OBJECT_DATA * od;
  struct object * xnode;
  int have_func = 0;
  int x=0;
  struct external_variable_context loc;

  if(atts!=NULL)
  for(i =0;; i=i+2)
  {
    if((atts[i]) == NULL) break;
/*    printf("%s: %s\n", (atts[i]), (atts[i+1])); */
  }  

#ifdef HAVE_XSLTSETLOADERFUNC
    push_svalue(&THIS->docloader);  

    if(Pike_sp[0-1].type == T_FUNCTION)
    {
      have_func = 1;
      xsltSetLoaderFunc(pike_docloader_conv);
    }
    else
    {
      pop_stack();
      xsltSetLoaderFunc(NULL);
    }
#endif
 

  output = xsltApplyStylesheet(THIS->object_data->stylesheet, 
                                 OBJ2_NODE(xml)->object_data->node->doc, 
                                 atts);

  /* we pushed the stack, so let's pop it. */
  if(have_func)
  {
    pop_stack();
  }

  if(output == NULL)
  {
    pop_n_elems(args);
    Pike_error("unable to transform document.\n");
  }

  xnode = NEW_NODE();
  ns = OBJ2_NODE((xnode));
  od = (NODE_OBJECT_DATA *)(ns->object_data);

  od->refs = malloc(sizeof(INT32));
  (* od->refs)=1;

  if(output->children == NULL)
  {
    Pike_error("unable to find a node for the document.\n");
  }
  od->node = output->children;

  pop_stack();
  push_object(xnode);
}

/*! @decl string output(Node xml, int|void encoding)
 *!
 *!   render the applied stylesheet Node to a string.
 *!
 *! @param xml
 *!   the transformed xml object
 *! 
 *! @param encoding
 *!   an optional encoding for the string. if not supplied, defaults to 
 *!   ISO-8859-1 (ISO Latin 1). Valid options are found in 
 *!   @[Public.XML2.Constants], XML_CHAR_ENCODING*.
 *!
 *! @returns
 *!   the string representation of the transformed XML.
 */
#define f_Stylesheet_output_1_defined
ptrdiff_t f_Stylesheet_output_1_fun_num = 0;
void f_Stylesheet_output_1(INT32 args) {
#line 332 "Stylesheet.cmod"
struct object * xml;
#line 332 "Stylesheet.cmod"
if(args != 1) wrong_number_of_args_error("output",args,1);
#line 332 "Stylesheet.cmod"
if(Pike_sp[0-1].type != PIKE_T_OBJECT) SIMPLE_BAD_ARG_ERROR("output",1,"object");
#line 332 "Stylesheet.cmod"
debug_malloc_pass(xml=Pike_sp[0-1].u.object);
{
  xmlOutputBufferPtr xmlBuf;
  xmlCharEncodingHandlerPtr encoder;

  CHECK_NODE_PASSED(xml);
  encoder = xmlGetCharEncodingHandler((xmlCharEncoding)10);
 
  if(encoder == NULL) 
    Pike_error("unable to obtain encoder.\n");

  xmlBuf = xmlAllocOutputBuffer(encoder);

  xsltSaveResultTo( xmlBuf, OBJ2_NODE(xml)->object_data->node->doc, 
                       THIS->object_data->stylesheet);

  pop_n_elems(args);

  push_text(xmlBuf->conv->content);

  xmlOutputBufferClose(xmlBuf);
}

}
#define f_Stylesheet_output_2_defined
ptrdiff_t f_Stylesheet_output_2_fun_num = 0;
void f_Stylesheet_output_2(INT32 args) {
#line 355 "Stylesheet.cmod"
struct object * xml;
#line 355 "Stylesheet.cmod"
INT_TYPE encoding;
#line 355 "Stylesheet.cmod"
if(args != 2) wrong_number_of_args_error("output",args,2);
#line 355 "Stylesheet.cmod"
if(Pike_sp[0-2].type != PIKE_T_OBJECT) SIMPLE_BAD_ARG_ERROR("output",1,"object");
#line 355 "Stylesheet.cmod"
debug_malloc_pass(xml=Pike_sp[0-2].u.object);
#line 355 "Stylesheet.cmod"
if(Pike_sp[1-2].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("output",2,"int");
encoding=Pike_sp[1-2].u.integer;
#line 356 "Stylesheet.cmod"
{
  xmlOutputBufferPtr xmlBuf;
  xmlCharEncodingHandlerPtr encoder;

  CHECK_NODE_PASSED(xml);
  encoder = xmlGetCharEncodingHandler((xmlCharEncoding)encoding);

  if(encoder == NULL)
    Pike_error("unable to obtain encoder.\n");

  xmlBuf = xmlAllocOutputBuffer(encoder);

  xsltSaveResultTo( xmlBuf, OBJ2_NODE(xml)->object_data->node->doc, 
                       THIS->object_data->stylesheet);

  pop_n_elems(args);

  push_text_len(xmlBuf->conv->content, xmlBuf->conv->use);

  xmlOutputBufferClose(xmlBuf);
}

}

#if defined(f_Stylesheet_output_1_defined) || defined(f_Stylesheet_output_2_defined)
#define f_Stylesheet_output_defined
ptrdiff_t Stylesheet_f_Stylesheet_output_fun_num = 0;
void f_Stylesheet_output(INT32 args) {
  switch(args) {
   case 1:

#ifdef f_Stylesheet_output_1_defined
    f_Stylesheet_output_1(args);
    return;

#endif /* f_Stylesheet_output_1_defined */
    break;
   case 2:

#ifdef f_Stylesheet_output_2_defined
    f_Stylesheet_output_2(args);
    return;

#endif /* f_Stylesheet_output_2_defined */
    break;
   default:
    wrong_number_of_args_error("output",args,1);
  }
}

#endif /* f_Stylesheet_output_1_defined, f_Stylesheet_output_2_defined */
/*! @decl void set_attributes(mapping variables)
 *!
 *! set attributes for use by the stylesheet transformation
 *!
 *! @note
 *!  Currently, the input to this function is assumed to be UTF-8 encoded.
 *!  We should probably do that automagically.
 */
#define f_Stylesheet_set_attributes_defined
ptrdiff_t f_Stylesheet_set_attributes_fun_num = 0;
void f_Stylesheet_set_attributes(INT32 args) {
#line 386 "Stylesheet.cmod"
struct mapping * variables;
#line 386 "Stylesheet.cmod"
if(args != 1) wrong_number_of_args_error("set_attributes",args,1);
#line 386 "Stylesheet.cmod"
if(Pike_sp[0-1].type != PIKE_T_MAPPING) SIMPLE_BAD_ARG_ERROR("set_attributes",1,"mapping(mixed:mixed)");
#line 386 "Stylesheet.cmod"
debug_malloc_pass(variables=Pike_sp[0-1].u.mapping);
{
  int i;
  char** vars = NULL;
  vars = low_set_attributes(variables);
  THIS->object_data->atts = (const char **)vars;
  pop_stack();
  
}

}
#line 396 "Stylesheet.cmod"
char** low_set_attributes(struct mapping * variables)
{

  int varcount, i;
  struct keypair * k;
  INT32 e;
  xmlChar* value;
  char ** vars = NULL;
  const xmlChar* str;

  if ( variables != NULL ) 
  {
    struct svalue sind, sval;
    int tmpint=0;

    varcount = 0;

    if(THIS->object_data->atts != NULL)
    {
      free(THIS->object_data->atts);
      THIS->object_data->atts = NULL;
    }
    vars = malloc( sizeof(char *) * 
                  ( 1 + ((m_sizeof(variables)) * 2 )));
    MAPPING_LOOP(variables)  
    {
      sind = k->ind;
      sval = k->val;
      if(!(sind.type == T_STRING && sval.type == T_STRING)) 
      {
        continue;
      }
      /* index */
printf("name %s, value %s\n", sind.u.string->str, sval.u.string->str);
      str  = (const xmlChar *) sval.u.string->str;
      if ( xmlStrstr(str, (xmlChar*) "\n") == NULL ) 
      {
        if ( xmlStrchr(str, '"') ) 
        {
          if (xmlStrchr(str, '\'')) 
          {
            Pike_error("Param contains quote and double-quotes.");
            return;    
          }
          value = xmlStrdup((const xmlChar *)"'");
          value = xmlStrcat(value, str);
          value = xmlStrcat(value, (const xmlChar *)"'");
        }
        else 
        {
          value = xmlStrdup((const xmlChar *)"\"");
          value = xmlStrcat(value, str);
          value = xmlStrcat(value, (const xmlChar *)"\"");
        }              
      }
      else 
      {
        /* param contains newlines */
        value = xmlStrdup((const xmlChar *)"\"");
        value = xmlStrcat(value, (const xmlChar *)"\"");
      }
            
      str = (const xmlChar*) sind.u.string->str;

      /* namespaces are bad */
      if ( xmlStrchr(str, ':') ) 
        vars[tmpint++] = strdup("supressed");
      else
        vars[tmpint++] = strdup(str);
      vars[tmpint++] = value;
      if ( varcount > MAX_PARAMS )
        Pike_error("Too many params !");
      varcount++;
    }
    vars[tmpint] = NULL;
  }
  else 
  {
    vars = malloc(sizeof(char *));
    vars[0] = NULL;
  }

  for(i =0;; i=i+2)
  {
    if((vars[i]) == NULL) break;
    printf("%s: %s\n", (vars[i]), (vars[i+1]));
  }  
  return vars;
}

int check_stylesheet_created()
{
  if(THIS->object_data->stylesheet != NULL)
    return 1;
  Pike_error("Stylesheet not initialized.\n");
}


#undef internal_init_Stylesheet_defined
#define internal_init_Stylesheet_defined

#undef Stylesheet_event_handler_defined
#define Stylesheet_event_handler_defined
static void init_Stylesheet_struct(void)
#line 494 "Stylesheet.cmod"
{
  STYLESHEET_OBJECT_DATA * dta;
  xmlGenericErrorFunc my_error;

  dta = 
	(STYLESHEET_OBJECT_DATA*)malloc(sizeof(STYLESHEET_OBJECT_DATA));
    if (!dta)
        Pike_error("init_stylesheet: Out of memory!\n");

    dta->stylesheet = NULL;
    dta->atts = NULL;
    THIS->object_data = dta;

    my_error = my_xsltGenericErrorFunc; 
    xsltSetGenericErrorFunc(NULL, my_error);

}


#undef internal_exit_Stylesheet_defined
#define internal_exit_Stylesheet_defined

#undef Stylesheet_event_handler_defined
#define Stylesheet_event_handler_defined
static void exit_Stylesheet_struct(void)
#line 513 "Stylesheet.cmod"
{ 

  if((* THIS->object_data->refs)==1 && THIS->object_data->stylesheet != NULL)
  {
    /* we do this to trick xsltFreeStylesheet into not freeing the document. */
    /* this should prevent a segfault when two stylesheet objects are created */
    /* from the same xml document. */
    THIS->object_data->stylesheet->doc = NULL;
    xsltFreeStylesheet(THIS->object_data->stylesheet);
  }
  else
  {
   (*( THIS->object_data->refs)) --;
  }

  if(THIS->object_data->atts != NULL)
  {
    free(THIS->object_data->atts);
  }

  if(THIS->node != NULL)
  {
/* FIXME: this is a memory leak!!! */
    free_object(THIS->node);
  }

   if(THIS->object_data)
  {
    free(THIS->object_data);
  }
}

#ifdef Stylesheet_event_handler_defined
static void Stylesheet_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_Stylesheet_defined
  case PROG_EVENT_INIT: init_Stylesheet_struct(); break;

#endif /* internal_init_Stylesheet_defined */

#ifdef internal_exit_Stylesheet_defined
  case PROG_EVENT_EXIT: exit_Stylesheet_struct(); break;

#endif /* internal_exit_Stylesheet_defined */
  default: break; 
  }
}

#endif /* Stylesheet_event_handler_defined */
/*! @endclass
 */


/*! @endmodule
 */

/*! @endmodule
 */

/*! @endmodule
 */


#line 559 "Stylesheet.cmod"
void pike_init_xml2_stylesheet()
{
  
#ifdef class_Stylesheet_defined

#ifdef PROG_STYLESHEET_ID
#line 75 "Stylesheet.cmod"
  START_NEW_PROGRAM_ID(STYLESHEET);
#else
#line 75 "Stylesheet.cmod"
  start_new_program();

#endif /* PROG_STYLESHEET_ID */

#ifndef tObjImpl_STYLESHEET

#undef tObjImpl_STYLESHEET
#define tObjImpl_STYLESHEET tObj

#endif /* tObjImpl_STYLESHEET */

#ifdef THIS_STYLESHEET
  Stylesheet_storage_offset = ADD_STORAGE(struct Stylesheet_struct);
#endif /* THIS_STYLESHEET */

#ifdef var_node_Stylesheet_defined
  PIKE_MAP_VARIABLE("node", Stylesheet_storage_offset + OFFSETOF(Stylesheet_struct, node),
                    tObj, PIKE_T_OBJECT, 0);
#endif /* var_node_Stylesheet_defined */

#ifdef var_docloader_Stylesheet_defined
  PIKE_MAP_VARIABLE("docloader", Stylesheet_storage_offset + OFFSETOF(Stylesheet_struct, docloader),
                    tFuncV(tNone,tMix,tAny), PIKE_T_MIXED, 0);
#endif /* var_docloader_Stylesheet_defined */

#ifdef Stylesheet_event_handler_defined
  pike_set_prog_event_callback(Stylesheet_event_handler);

#endif /* Stylesheet_event_handler_defined */

#ifdef f_Stylesheet_set_docloader_defined
  f_Stylesheet_set_docloader_fun_num =
#line 108 "Stylesheet.cmod"
    ADD_FUNCTION2("set_docloader", f_Stylesheet_set_docloader, tFunc(tFuncV(tNone,tMix,tAny),tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Stylesheet_set_docloader_defined */

#ifdef f_Stylesheet_clear_xslt_docloader_defined
  f_Stylesheet_clear_xslt_docloader_fun_num =
#line 124 "Stylesheet.cmod"
    ADD_FUNCTION2("clear_xslt_docloader", f_Stylesheet_clear_xslt_docloader, tFunc(tNone,tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Stylesheet_clear_xslt_docloader_defined */

#ifdef f_Stylesheet_cq__sprintf_defined
  f_Stylesheet_cq__sprintf_fun_num =
#line 172 "Stylesheet.cmod"
    ADD_FUNCTION2("_sprintf", f_Stylesheet_cq__sprintf, tFunc("\10\200\0\0\0\177\377\377\377" tMix,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Stylesheet_cq__sprintf_defined */

#ifdef f_Stylesheet_create_defined
  f_Stylesheet_create_fun_num =
#line 181 "Stylesheet.cmod"
    ADD_FUNCTION2("create", f_Stylesheet_create, tFunc(tNone,tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Stylesheet_create_defined */

#ifdef f_Stylesheet_output_type_defined
  f_Stylesheet_output_type_fun_num =
#line 209 "Stylesheet.cmod"
    ADD_FUNCTION2("output_type", f_Stylesheet_output_type, tFunc(tNone,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Stylesheet_output_type_defined */

#ifdef f_Stylesheet_media_type_defined
  f_Stylesheet_media_type_fun_num =
#line 224 "Stylesheet.cmod"
    ADD_FUNCTION2("media_type", f_Stylesheet_media_type, tFunc(tNone,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Stylesheet_media_type_defined */

#ifdef f_Stylesheet_apply_defined
  Stylesheet_f_Stylesheet_apply_fun_num =
#line 237 "Stylesheet.cmod"
    ADD_FUNCTION2("apply", f_Stylesheet_apply, tOr(tFunc(tObj,tObj),tFunc(tObj tMapping,tObj)), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Stylesheet_apply_defined */

#ifdef f_Stylesheet_output_defined
  Stylesheet_f_Stylesheet_output_fun_num =
#line 355 "Stylesheet.cmod"
    ADD_FUNCTION2("output", f_Stylesheet_output, tOr(tFunc(tObj,tString),tFunc(tObj "\10\200\0\0\0\177\377\377\377",tString)), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Stylesheet_output_defined */

#ifdef f_Stylesheet_set_attributes_defined
  f_Stylesheet_set_attributes_fun_num =
#line 386 "Stylesheet.cmod"
    ADD_FUNCTION2("set_attributes", f_Stylesheet_set_attributes, tFunc(tMapping,tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Stylesheet_set_attributes_defined */
#line 76 "Stylesheet.cmod"
  Pike_compiler->new_program->flags |= PROGRAM_USES_PARENT;
#line 75 "Stylesheet.cmod"
  Stylesheet_program=end_program();
#line 75 "Stylesheet.cmod"
  Stylesheet_program_fun_num=add_program_constant("Stylesheet",Stylesheet_program,0);

#endif /* class_Stylesheet_defined */
#line 562 "Stylesheet.cmod"
}

void pike_exit_xml2_stylesheet()
{
  
#ifdef class_Stylesheet_defined
  if(Stylesheet_program) {
#line 75 "Stylesheet.cmod"
    free_program(Stylesheet_program);
    Stylesheet_program=0;
  }

#endif /* class_Stylesheet_defined */
#line 567 "Stylesheet.cmod"
}

