#!/usr/bin/python

import sys

loaded_module_name = None
inst = None

def _check_inst():
    if inst is None:
        raise RuntimeError, "no installer has been set"

def set_installer(name, module_dir = None):
    global loaded_module_name
    global inst

    if inst is not None:
        if name != loaded_module_name:
            raise RuntimeError, "cannot load two different installer modules"
    else:
        if module_dir:
            sys.path.append(module_dir)

        inst_toplevel = None
        namespace = None
        for parent_module in ("picax_modules", "picax.modules"):
            try:
                full_name = parent_module + "." + name
                inst_toplevel = __import__(full_name)
                namespace = parent_module
                break
            except:
                pass

        if not inst_toplevel:
            raise RuntimeError, "could not find install module for %s" \
                  % (name,)

        if hasattr(inst_toplevel, name):
            inst = getattr(inst_toplevel, name)
        elif hasattr(inst_toplevel, "modules") and \
             hasattr(inst_toplevel.modules, name):
            inst = getattr(inst_toplevel.modules, name)
        else:
            raise RuntimeError, "cannot find install modules for %s" \
                  % (name,)

        loaded_module_name = name

def get_options():
    _check_inst()

    return inst.get_options()

def get_package_requests():
    _check_inst()

    return inst.get_package_requests()

def install(cd_path):
    _check_inst()

    inst.install(cd_path)

def post_install(cd_path):
    _check_inst()

    inst.post_install(cd_path)

def get_media_builder():
    _check_inst()

    if inst.__dict__.has_key("get_media_builder"):
        return inst.get_media_builder()
    else:
        return None
