<?php
	/**
	* XMLRPC response
	* @author Edd Dumbill <edd@usefulinc.com>
	* @copyright Copyright (C) 1999-2001 Edd Dumbill
	* @copyright Portions Copyright (C) 2004 Free Software Foundation, Inc. http://www.fsf.org/
	* @license http://www.fsf.org/licenses/lgpl.html GNU Lesser General Public License
	* @package phpgwapi
	* @subpackage xml
	* @version $Id: class.xmlrpcresp.inc.php,v 1.5.4.2 2004/02/10 13:51:19 ceb Exp $
	*/

	// License is granted to use or modify this software ("XML-RPC for PHP")
	// for commercial or non-commercial use provided the copyright of the author
	// is preserved in any distributed or derivative work.

	// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESSED OR
	// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
	// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
	// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
	// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
	// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
	// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
	// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
	// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
	// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


	/**
	* XMLRPC response
	* 
	* @package phpgwapi
	* @subpackage xml
	*/
	class xmlrpcresp
	{
		var $xv = array();
		var $fn;
		var $fs = '';
		var $hdrs;

		function xmlrpcresp($val='', $fcode=0, $fstr='')
		{
			if ($fcode!=0)
			{
				$this->xv = 0;
				$this->fn = $fcode;
				$this->fs = htmlspecialchars($fstr);
			}
			else
			{
				if($val)
				{
					$this->xv = $val;
				}
				$this->fn = 0;
			}
		}

		function faultCode()
		{
			if (isset($this->fn)) 
			{
				return $this->fn;
			}
			else
			{
				return 0;
			}
		}

		function faultString()
		{
			return $this->fs;
		}

		function value()
		{
			return $this->xv;
		}

		function serialize()
		{
			$rs='<methodResponse>'."\n";
			if (isset($this->fn) && !empty($this->fn))
			{
				$rs .= '<fault>
  <value>
    <struct>
      <member>
        <name>faultCode</name>
        <value><int>' . $this->fn . '</int></value>
      </member>
      <member>
        <name>faultString</name>
        <value><string>' . $this->fs . '</string></value>
      </member>
    </struct>
  </value>
</fault>';
			}
			else
			{
				$rs .= '<params>'."\n".'<param>'."\n".@$this->xv->serialize().'</param>'."\n".'</params>';
			}
			$rs.="\n".'</methodResponse>';
			return $rs;
		}
	}
?>
