<?php
  /**************************************************************************\
  * phpGroupWare - phpgw_dj                                                  *
  * http://www.phpgroupware.org                                              *
  * Written by: Miles Lott <milosch@phpgroupware.org>                        *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

  /* $Id: view.php,v 1.10 2001/09/15 12:02:51 milosch Exp $ */

	$GLOBALS['phpgw_info']['flags'] = array(
		'currentapp' => 'dj',
		'enable_categories_class' => True
	);
	include('../header.inc.php');

	if (!$song_id)
	{
		Header('Location: ' . $GLOBALS['phpgw']->link('/dj/index.php'));
		$GLOBALS['phpgw']->common->phpgw_exit();
	}

	$GLOBALS['phpgw']->template->set_file(array('view' => 'view.tpl'));
	$GLOBALS['phpgw']->template->set_block('view','form','form');
	$GLOBALS['phpgw']->template->set_block('view','footer','footer');

	$GLOBALS['phpgw']->template->set_var('hidden_vars','');

	if ($new_cat)
	{
		$cat_id = $new_cat;
	}

	$GLOBALS['phpgw']->db->query("SELECT * FROM phpgw_dj_songlist WHERE song_id='$song_id'");
	$GLOBALS['phpgw']->db->next_record();

	$GLOBALS['phpgw']->template->set_var('song_name',$GLOBALS['phpgw']->db->f('song_name'));
	$GLOBALS['phpgw']->template->set_var('song_title',$GLOBALS['phpgw']->db->f('song_title'));
	$GLOBALS['phpgw']->template->set_var('song_artist',$GLOBALS['phpgw']->db->f('song_artist'));
	$GLOBALS['phpgw']->template->set_var('song_album',$GLOBALS['phpgw']->db->f('song_album'));
	$GLOBALS['phpgw']->template->set_var('song_year',$GLOBALS['phpgw']->db->f('song_year'));
	$GLOBALS['phpgw']->template->set_var('song_comment',$GLOBALS['phpgw']->db->f('song_comment'));
	$GLOBALS['phpgw']->template->set_var('genre_option',$GLOBALS['phpgw']->db->f('song_genre'));
	$GLOBALS['phpgw']->template->set_var('song_size',nicesize($GLOBALS['phpgw']->db->f('song_size')));
	$GLOBALS['phpgw']->template->set_var('song_length',date('i:s',$GLOBALS['phpgw']->db->f('song_length')));
	$GLOBALS['phpgw']->template->set_var('song_bitrate',$GLOBALS['phpgw']->db->f('song_bitsize') . lang('kb/s'));
	$GLOBALS['phpgw']->template->set_var('song_samplerate',$GLOBALS['phpgw']->db->f('song_samplerate') . lang('hz'));
	$GLOBALS['phpgw']->template->set_var('song_frames',$GLOBALS['phpgw']->db->f('song_frames'));
	$GLOBALS['phpgw']->template->set_var('song_emphasis',$GLOBALS['phpgw']->db->f('song_emphasis'));
	$GLOBALS['phpgw']->template->set_var('song_cmode',$GLOBALS['phpgw']->db->f('song_cmode'));
	$GLOBALS['phpgw']->template->set_var('song_version',$GLOBALS['phpgw']->db->f('song_version'));
	$GLOBALS['phpgw']->template->set_var('song_layer',$GLOBALS['phpgw']->db->f('song_layer'));

	if ($GLOBALS['phpgw']->db->f('song_crc'))
	{
		$GLOBALS['phpgw']->template->set_var('song_crc',lang('disabled'));
	}
	else
	{
		$GLOBALS['phpgw']->template->set_var('song_crc',lang('enabled'));
	}

	if ($GLOBALS['phpgw']->db->f('song_copyright'))
	{
		$GLOBALS['phpgw']->template->set_var('song_copyright',lang('Yes'));
	}
	else
	{
		$GLOBALS['phpgw']->template->set_var('song_copyright',lang('No'));
	}

	if($GLOBALS['phpgw']->db->f('song_original'))
	{
		$GLOBALS['phpgw']->template->set_var('song_original',lang('Yes'));
	}
	else
	{
		$GLOBALS['phpgw']->template->set_var('song_original',lang('No'));
	}

	if($GLOBALS['phpgw']->db->f('song_status') == 'A')
	{
		$GLOBALS['phpgw']->template->set_var('song_status',lang('Available'));
	}
	else
	{
		$GLOBALS['phpgw']->template->set_var('song_status',lang('Unavailable'));
	}

	if($GLOBALS['phpgw']->db->f('song_cycle_status') == 'A')
	{
		$GLOBALS['phpgw']->template->set_var('song_cycle_status',lang('Available'));
	}
	else
	{
		$GLOBALS['phpgw']->template->set_var('song_cycle_status',lang('Played'));
	}

	$GLOBALS['phpgw']->template->set_var('lang_name',lang('File Name'));
	$GLOBALS['phpgw']->template->set_var('lang_title',lang('Title'));
	$GLOBALS['phpgw']->template->set_var('lang_artist',lang('Artist'));
	$GLOBALS['phpgw']->template->set_var('lang_album',lang('Album'));
	$GLOBALS['phpgw']->template->set_var('lang_year',lang('Year'));
	$GLOBALS['phpgw']->template->set_var('lang_comment',lang('Comment'));
	$GLOBALS['phpgw']->template->set_var('lang_genre',lang('Genre'));
	$GLOBALS['phpgw']->template->set_var('lang_size',lang('File Size'));
	$GLOBALS['phpgw']->template->set_var('lang_length',lang('Length'));
	$GLOBALS['phpgw']->template->set_var('lang_bitrate',lang('Bitrate'));
	$GLOBALS['phpgw']->template->set_var('lang_samplerate',lang('Sample Rate'));
	$GLOBALS['phpgw']->template->set_var('lang_frames',lang('Frames'));
	$GLOBALS['phpgw']->template->set_var('lang_emphasis',lang('Emphasis'));
	$GLOBALS['phpgw']->template->set_var('lang_cmode',lang('Channel Mode'));
	$GLOBALS['phpgw']->template->set_var('lang_version',lang('Version'));
	$GLOBALS['phpgw']->template->set_var('lang_layer',lang('Layer'));
	$GLOBALS['phpgw']->template->set_var('lang_crc',lang('Error Correction'));
	$GLOBALS['phpgw']->template->set_var('lang_copyright',lang('Copyright'));
	$GLOBALS['phpgw']->template->set_var('lang_original',lang('Original'));
	$GLOBALS['phpgw']->template->set_var('lang_status',lang('Status'));
	$GLOBALS['phpgw']->template->set_var('lang_cycle_status',lang('Cycle Status'));
	$GLOBALS['phpgw']->template->set_var('lang_edit',lang('Edit'));

	$GLOBALS['phpgw']->template->set_var('song_id',$song_id);
	$GLOBALS['phpgw']->template->set_var('sort',$sort);
	$GLOBALS['phpgw']->template->set_var('order',$order);
	$GLOBALS['phpgw']->template->set_var('filter',$filter);
	$GLOBALS['phpgw']->template->set_var('query',$query);
	$GLOBALS['phpgw']->template->set_var('start',$start);
	$GLOBALS['phpgw']->template->set_var('cat_id',$cat_id);
	$GLOBALS['phpgw']->template->set_var('lang_done',lang('Done'));
	$GLOBALS['phpgw']->template->set_var('lang_view',lang('View'));
	$GLOBALS['phpgw']->template->set_var('lang_cancel',lang('cancel'));
	$GLOBALS['phpgw']->template->set_var('lang_submit',lang('submit'));
	$GLOBALS['phpgw']->template->set_var('lang_request',lang('request'));
	$GLOBALS['phpgw']->template->set_var('edit_link','<form method="POST" action="' . $GLOBALS['phpgw']->link('/dj/edit.php','song_id=' . $song_id) . '">');
	$GLOBALS['phpgw']->template->set_var('done_link','<form method="POST" action="' . $GLOBALS['phpgw']->link('/dj/index.php') . '">');
	$GLOBALS['phpgw']->template->set_var('request_link',$GLOBALS['phpgw']->link('/dj/request.php','song_id=' . $song_id));

	//$GLOBALS['phpgw']->template->set_var('delete_link','<form method="POST" action="'.$GLOBALS['phpgw']->link('/dj/delete.php') . '">');
	$GLOBALS['phpgw']->template->set_var('delete_link','');
	//$GLOBALS['phpgw']->template->set_var('delete_button','<input type="submit" name="delete" value="' . lang('Delete') . '">');
	$GLOBALS['phpgw']->template->set_var('delete_button','');

	$GLOBALS['phpgw']->template->pparse('out','form');
	$GLOBALS['phpgw']->template->pparse('out','footer');

	$GLOBALS['phpgw']->common->phpgw_footer();
?>
