<?php
  /**************************************************************************\
  * phpgwTimeTrack - Setup                                                   *
  * http://www.phpgroupware.org                                              *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

  /* $Id: setup_groups.inc.php,v 1.2 2001/06/12 15:04:11 rschader Exp $ */

    // Setup the manage_jobs acl
	// See if I can easily replace the sql code with api calls here
    echo "Creating TTrack_Managers group and manage_jobs ACL's...<br>";
	$n_group = "TTrack_Managers";
	$account_expires = -1;
	if ($phpgw->accounts->exists($n_group))
	{
		echo 'Warning: TTrack_Managers group already exists<br>';
	} else {
		$group = CreateObject('phpgwapi.accounts',$mgrgrpid);
		$account_info = array(
			'account_type'      => 'g',
			'account_lid'       => $n_group,
			'account_passwd'    => '',
			'account_firstname' => $n_group,
			'account_lastname'  => 'Group',
			'account_status'    => 'A',
			'account_expires'   => $account_expires
		);
		$group->create($account_info);
	}
	$mgrgrpid = $phpgw->accounts->name2id($n_group);

	$acl = CreateObject('phpgwapi.acl',$mgrgrpid);
	$acl->read_repository();
	$acl->add("timetrack", "manage_jobs", 1);
	$acl->save_repository();

   	// Setup the payroll acl
   	echo "Creating TTrack_Payroll group and payroll ACL's...<br>";
	$n_group = "TTrack_Payroll";
	if ($phpgw->accounts->exists($n_group))
	{
		echo 'Warning: TTrack_Payroll group already exists<br>';
	} else {
		$group = CreateObject('phpgwapi.accounts',$paygrpid);
		$account_info = array(
			'account_type'      => 'g',
			'account_lid'       => $n_group,
			'account_passwd'    => '',
			'account_firstname' => $n_group,
			'account_lastname'  => 'Group',
			'account_status'    => 'A',
			'account_expires'   => $account_expires
		);
		$group->create($account_info);
	}
	$paygrpid = $phpgw->accounts->name2id($n_group);

	$acl = CreateObject('phpgwapi.acl',$paygrpid);
	$acl->read_repository();
	$acl->add("timetrack", "manage_payroll", 1);
	$acl->save_repository();

?>
