<?php
	/**************************************************************************\
	* phpGroupWare - Inventory Prefs                                           *
	* (http://www.phpgroupware.org)                                            *
	* Written by Bettina Gille  [ceb@phpgroupware.org]                         * 
	* ------------------------------------------------                         *
	* This program is free software; you can redistribute it and/or modify it  *
	* under the terms of the GNU General Public License as published by the    *
	* Free Software Foundation; either version 2 of the License, or (at your   *
	* option) any later version.                                               *
	\**************************************************************************/
	/* $Id: preferences.php,v 1.22 2001/06/30 23:06:20 bettina Exp $ */

	$phpgw_info['flags'] = array('currentapp' => 'inv',
									'noheader' => True,
									'nonavbar' => True,
								'noappheader' => True,
								'noappfooter' => True);

	include('../header.inc.php');

	if ($submit)
	{
		$phpgw->preferences->change('inv','abid');
		$phpgw->preferences->change('inv','print_format');
		$phpgw->preferences->commit(True);

		Header('Location: ' . $phpgw->link('/preferences/index.php'));
		$phpgw->common->phpgw_exit();
	}

	$phpgw->common->phpgw_header();
	echo parse_navbar();

	if ($totalerrors)
	{
		echo '<p><center>' . $phpgw->common->error_list($errors) . '</center>';
	}

	$t = CreateObject('phpgwapi.Template',PHPGW_APP_TPL);
	$t->set_file(array('prefs' => 'preferences.tpl'));

	$t->set_var('actionurl',$phpgw->link('/inv/preferences.php'));
	$t->set_var('addressbook_link',$phpgw->link('/inv/addressbook.php','query='));
	$t->set_var('lang_action',lang('Inventory preferences'));
	$t->set_var('lang_address',lang('Select your address'));
	$t->set_var('lang_select',lang('Select per button !'));                                                                                                                                         

	$d = CreateObject('phpgwapi.contacts');
	if (isset($phpgw_info['user']['preferences']['inv']['abid']))
	{
		$abid = $phpgw_info['user']['preferences']['inv']['abid'];
		$cols = array('n_given' => 'n_given',
					'n_family' => 'n_family',
					'org_name' => 'org_name');                                                                                                                                 

		$entry = $d->read_single_entry($abid,$cols);
		if (!$entry[0]['org_name']) { $t->set_var('name',$entry[0]['n_given'] . ' ' . $entry[0]['n_family']); } 
		else { $t->set_var('name',$entry[0]['org_name'] . ' [ ' . $entry[0]['n_given'] . ' ' . $entry[0]['n_family'] . ' ]'); }
	}
	else
	{
		$t->set_var('name',$name);
	}

	$t->set_var('abid',$abid);
	$t->set_var('lang_print_format',lang('Select print format'));

	if ($phpgw_info['user']['preferences']['inv']['print_format']=='html'):
		$format_sel[0]=' selected';
	elseif ($phpgw_info['user']['preferences']['inv']['print_format']=='pdf'):
		$format_sel[1]=' selected';
	endif;

	$print_format = '<option value="html"' . $format_sel[0] .'>' . lang('HTML') . '</option>' . "\n"
				. '<option value="pdf"' . $format_sel[1] . '>' . lang('PDF') . '</option>' . "\n";

	$t->set_var('print_format',$print_format);
	$t->set_var('lang_edit',lang('Edit'));
	$t->pparse('out','prefs');
	$phpgw->common->phpgw_footer();
?>
