<?php
/**
*
* acp_board.php [Norwegian Bokmaal]
*
* @package language
* @version $Id: $
* @copyright (c) 2008 phpBB Group
* @author 2008-03-15 - phpBB.no
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine

$lang = array_merge($lang, array(
	'ACP_BOARD_SETTINGS_EXPLAIN'	=> 'Her kan du bestemme en rekke viktige standardinnstillinger, som forumnavn og beskrivelse og innstillinger for tidssone, språk, design m.m.',
	'CUSTOM_DATEFORMAT'	=> 'Brukerdefinert&hellip;',
	'DEFAULT_DATE_FORMAT'	=> 'Datoformat',
	'DEFAULT_DATE_FORMAT_EXPLAIN'	=> 'Datoformatet er det samme som PHPs <code>date</code>-funksjon.',
	'DEFAULT_LANGUAGE'	=> 'Standardspråk',
	'DEFAULT_STYLE'	=> 'Standarddesign',
	'DISABLE_BOARD'	=> 'Deaktiver frumet',
	'DISABLE_BOARD_EXPLAIN'	=> 'Dette vil gjøre forumet utilgjengelig. Du kan velge å skrive en kort beskjed som vises i stedet (maksimalt 255 tegn).',
	'OVERRIDE_STYLE'	=> 'Overskriv brukernes design',
	'OVERRIDE_STYLE_EXPLAIN'	=> 'Erstatter brukernes design med standarddesignet.',
	'SITE_DESC'	=> 'Beskrivelse',
	'SITE_NAME'	=> 'Forumnavn',
	'SYSTEM_DST'	=> 'Aktiver sommertid/<abbr title="Daylight Saving Time">DST</abbr>',
	'SYSTEM_TIMEZONE'	=> 'Tidssone',
	'WARNINGS_EXPIRE'	=> 'Advarselsvarighet',
	'WARNINGS_EXPIRE_EXPLAIN'	=> 'Antall dager fra en advarsel gis til den fjernes fra brukerens profildata.',
	'ACP_BOARD_FEATURES_EXPLAIN'	=> 'Her kan du aktivere/deaktivere flere av forumets funksjoner.',
	'ALLOW_ATTACHMENTS'	=> 'Tillat vedlegg',
	'ALLOW_BIRTHDAYS'	=> 'Tillat bursdager',
	'ALLOW_BIRTHDAYS_EXPLAIN'	=> 'Tillater at visning av fødseldato og alder kan vises i brukerprofilen. Vær oppmerksom på at visningen av bursdagsdagslisten nederst på forumets hovedside kontrolleres av en egen innstilling under Serverkonfigurasjon/Belastningsinnstillinger.',
	'ALLOW_BOOKMARKS'	=> 'Tillat bokmerker på emner',
	'ALLOW_BOOKMARKS_EXPLAIN'	=> 'Tillater at brukere kan lagre personlige bokmerker.',
	'ALLOW_BBCODE'	=> 'Aktiver BBkode',
	'ALLOW_FORUM_NOTIFY'	=> 'Tillat forumovervåking',
	'ALLOW_NAME_CHANGE'	=> 'Tillat endring av brukernavn',
	'ALLOW_NO_CENSORS'	=> 'Tillat deaktivering av ordsensur',
	'ALLOW_NO_CENSORS_EXPLAIN'	=> 'Tillater at brukere kan deaktivere ordsensur i innlegg og private meldinger.',
	'ALLOW_PM_ATTACHMENTS'	=> 'Tillat vedlegg i private meldinger',
	'ALLOW_SIG'	=> 'Tillat signaturer',
	'ALLOW_SIG_BBCODE'	=> 'Tillat BBkode i signaturer',
	'ALLOW_SIG_FLASH'	=> 'Tillat bruk av BBkoden <code>[FLASH]</code> i signaturer',
	'ALLOW_SIG_IMG'	=> 'Tillat bruk av BBkoden <code>[IMG]</code>  i signaturer',
	'ALLOW_SIG_LINKS'	=> 'Tillat bruk av linker i signaturer',
	'ALLOW_SIG_LINKS_EXPLAIN'	=> 'Hvis bruk av BBkoden <code>[URL]</code> forbys, avbrytes samtidig automatiske (magiske) URL-er.',
	'ALLOW_SIG_SMILIES'	=> 'Tillat bruk av smilies i signaturer',
	'ALLOW_SMILIES'	=> 'Tillat smilies',
	'ALLOW_TOPIC_NOTIFY'	=> 'Tillat emneovervåking',
	'BOARD_PM'	=> 'Tillat private meldinger',
	'BOARD_PM_EXPLAIN'	=> 'Aktiverer muligheten for private meldinger.',
	'ACP_AVATAR_SETTINGS_EXPLAIN'	=> 'Avatarer er generelt små bilder en bruker kan knytte til sin profil. Avhenger av forumets design vises disse oftest like under brukernavnet når man leser et innlegg. Herfra styrer du hvordan brukerne kan definere avataren deres. Vær oppmerksom på at for å kunne laste opp avatarer, skal du på forhånd ha opprettet en angitt mappe og sikre deg at den kan skrives til fra serveren. Begrensingene for filstørrelse brukes kun på opplastede avatarer, ikke de eksterne.',
	'ALLOW_LOCAL'	=> 'Aktiver avatargalleri',
	'ALLOW_REMOTE'	=> 'Tillat eksterne avatarer',
	'ALLOW_REMOTE_EXPLAIN'	=> 'Tillater avatarer som er tilgjengelige på internett.',
	'ALLOW_UPLOAD'	=> 'Tillat opplasting av avatarer',
	'AVATAR_GALLERY_PATH'	=> 'Avatargallerimappens plassering',
	'AVATAR_GALLERY_PATH_EXPLAIN'	=> 'Sti til phpBB-rotmappen for forhåndsopplastede avatarer, f.eks. <samp>images/avatars/gallery/</samp>.',
	'AVATAR_STORAGE_PATH'	=> 'Avatarmappens plassering',
	'AVATAR_STORAGE_PATH_EXPLAIN'	=> 'Sti til din phpBB-rotmappe for opplastede avatarer, f.eks. <samp>images/avatars/upload/</samp>.',
	'MAX_AVATAR_SIZE'	=> 'Største tillatte dimensjoner for avatarer',
	'MAX_AVATAR_SIZE_EXPLAIN'	=> 'Høyde x bredde i piksler.',
	'MAX_FILESIZE'	=> 'Maksimal filstørrelse for avatarer',
	'MAX_FILESIZE_EXPLAIN'	=> 'Maksimal tillatt filstørrelse for opplastede avatarer.',
	'MIN_AVATAR_SIZE'	=> 'Minste tillatte dimensjoner for avatarer',
	'MIN_AVATAR_SIZE_EXPLAIN'	=> 'Høyde x bredde i piksler.',
	'ACP_MESSAGE_SETTINGS_EXPLAIN'	=> 'Her kan du tilpasse alle standardinnstillinger for private meldinger.',
	'ALLOW_BBCODE_PM'	=> 'Aktiver BBkode i private meldinger',
	'ALLOW_FLASH_PM'	=> 'Tillat bruk av BBkoden <code>[FLASH]</code>',
	'ALLOW_FLASH_PM_EXPLAIN'	=> 'Vær oppmerksom på at for at muligheten for å bruke Flash i private meldinger skal tre i kraft, skal muligheten for å bruke Flash også være tillatt i de overordnede rettigheters innstillinger.',
	'ALLOW_FORWARD_PM'	=> 'Tillat videresending av private meldinger',
	'ALLOW_IMG_PM'	=> 'Tillat bruk av BBkoden <code>[IMG]</code>',
	'ALLOW_MASS_PM'	=> 'Tillat sending av private meldinger til flere brukere og grupper',
	'ALLOW_PRINT_PM'	=> 'Tillat utskriftsvennlig visning av private meldinger',
	'ALLOW_QUOTE_PM'	=> 'Tillat sitater i private meldinger',
	'ALLOW_SIG_PM'	=> 'Tillat signaturer i private meldinger',
	'ALLOW_SMILIES_PM'	=> 'Tillat smilies i private meldinger',
	'BOXES_LIMIT'	=> 'Maksimalt antall private meldinger i hver mappe',
	'BOXES_LIMIT_EXPLAIN'	=> 'Brukerne kan ikke lagre flere enn dette antall meldinger i hver av deres mapper. Sett til 0 for ubegrenset antall.',
	'BOXES_MAX'	=> 'Maksimalt antall mapper for private meldinger',
	'BOXES_MAX_EXPLAIN'	=> 'Brukerne kan ikke opprette flere enn dette antall mapper for private meldinger.',
	'ENABLE_PM_ICONS'	=> 'Aktiver bruk av emneikoner i private meldinger',
	'FULL_FOLDER_ACTION'	=> 'Handling ved full mappe',
	'FULL_FOLDER_ACTION_EXPLAIN'	=> 'Utfør standardhandling hvis en brukers mappe er full og eventuelle brukerdefinerte mappehandlinger ikke er brukbare. Eneste unntak er mappen "Sendte meldinger", hvor standardhandlingen alltid er sletting av eldste meldinger.',
	'HOLD_NEW_MESSAGES'	=> 'Hold tilbake nye meldinger',
	'PM_EDIT_TIME'	=> 'Begrens redigeringstid',
	'PM_EDIT_TIME_EXPLAIN'	=> 'Begrenser hvor lenge en ennå ikke levert melding kan redigeres. Sett til 0 for å deaktivere denne begrensningen.',
	'ACP_POST_SETTINGS_EXPLAIN'	=> 'Her kan du tilpasse alle standardinnstillinger for å skrive innlegg.',
	'ALLOW_POST_LINKS'	=> 'Tillat bruk av linker i innlegg og private meldinger',
	'ALLOW_POST_LINKS_EXPLAIN'	=> 'Hvis bruk av linker ikke er tillatt, er BBkoden for URL-er og automatiske (magiske) URL-er deaktivert.',
	'ALLOW_POST_FLASH'	=> 'Tillat bruk av BBkoden <code>[FLASH]</code> i innlegg. ',
	'ALLOW_POST_FLASH_EXPLAIN'	=> 'Hvis bruk av Flash ikke er tillatt, er ikke BBkoden <code>[FLASH]</code> synlig når det skrives innlegg. Ellers kan rettighetssystemet brukes til å definere hvilke brukere som kan bruke BBkoden <code>[FLASH]</code>.',
	'BUMP_INTERVAL'	=> 'Intervall for plassering øverst',
	'BUMP_INTERVAL_EXPLAIN'	=> 'Antall minutter, timer eller dager siden siste innlegg i et emne før det kan plasseres øverst. Sett til 0 for å deaktivere denne funksjonaliteten.',
	'CHAR_LIMIT'	=> 'Maksimalt antall tegn i innlegg',
	'CHAR_LIMIT_EXPLAIN'	=> 'Det maksimale antall tegn tillatt i et innlegg. Sett til 0 for å deaktivere denne begrensningen.',
	'DISPLAY_LAST_EDITED'	=> 'Vis siste redigerete',
	'DISPLAY_LAST_EDITED_EXPLAIN'	=> 'Velg om seneste redigeringstidspunkt skal vises i innlegg.',
	'EDIT_TIME'	=> 'Begrens tidsrom for redigering',
	'EDIT_TIME_EXPLAIN'	=> 'Begrenser tidsrommet hvor man kan redigere et nytt innlegg. Sett til 0 for å deaktivere denne begrensningen.',
	'FLOOD_INTERVAL'	=> 'Intervall mellom nye innlegg',
	'FLOOD_INTERVAL_EXPLAIN'	=> 'Antall sekunder en bruker må vente mellom å sende inn nye inndlegg. For å la brukerne ignorere denne innstillingen, kan du endre dette i deres rettigheter.',
	'HOT_THRESHOLD'	=> 'Innleggsgrense for populært emne',
	'HOT_THRESHOLD_EXPLAIN'	=> 'Antall innlegg et emne må ha for at dette skal kategoriseres som populært. Sett til 0 for å deaktivere denne muligheten.',
	'MAX_POLL_OPTIONS'	=> 'Maksimalt antall avstemningsmuligheter',
	'MAX_POST_FONT_SIZE'	=> 'Maksimal skriftstørrelse i innlegg',
	'MAX_POST_FONT_SIZE_EXPLAIN'	=> 'Den maksimale tillatte skriftstørrelse i innlegg. Sett til 0 for å deaktivere denne begrensningen.',
	'MAX_POST_IMG_HEIGHT'	=> 'Maksimal bildehøyde i innlegg',
	'MAX_POST_IMG_HEIGHT_EXPLAIN'	=> 'Maksimalhøyde på bilder og Flash-filer i innlegg. Sett til 0 for ubegrenset høyde.',
	'MAX_POST_IMG_WIDTH'	=> 'Maksimal bildebredde i innlegg',
	'MAX_POST_IMG_WIDTH_EXPLAIN'	=> 'Maksimal bredde på bilder og Flash-filer i innlegg. Sett til 0 for ubegrenset bredde.',
	'MAX_POST_URLS'	=> 'Maksimalt antall linker i innlegg',
	'MAX_POST_URLS_EXPLAIN'	=> 'Høyeste antall linker i innlegg. Sett til 0 for ubegrenset antall.',
	'POSTING'	=> 'Innlegg',
	'POSTS_PER_PAGE'	=> 'Innlegg på hver side',
	'QUOTE_DEPTH_LIMIT'	=> 'Maksimalt antall sitater i innlegg',
	'QUOTE_DEPTH_LIMIT_EXPLAIN'	=> 'Definerer hvor mange ganger et tidligere sitat kan innflettes. Sett til 0 for ubegrenset.',
	'SMILIES_LIMIT'	=> 'Maksimalt antall smilies i innleggg',
	'SMILIES_LIMIT_EXPLAIN'	=> 'Sett til 0 for ubegrenset antall.',
	'TOPICS_PER_PAGE'	=> 'Emner på hver side',
	'ACP_SIGNATURE_SETTINGS_EXPLAIN'	=> 'Her kan du tilpasse alle standardinnstillinger for signaturer.',
	'MAX_SIG_FONT_SIZE'	=> 'Maksimal skriftstørrelse i signaturer',
	'MAX_SIG_FONT_SIZE_EXPLAIN'	=> 'Maksimal skriftstørrelse tillatt i brukersignaturer. Sett til 0 for ubegrenset størrelse.',
	'MAX_SIG_IMG_HEIGHT'	=> 'Maksimal bildehøyde i signaturer',
	'MAX_SIG_IMG_HEIGHT_EXPLAIN'	=> 'Maksimal høyde på bilder og Flash-filer i signaturer. Sett til 0 for ubegrenset høyde.',
	'MAX_SIG_IMG_WIDTH'	=> 'Maksimal bildebredde i signaturer',
	'MAX_SIG_IMG_WIDTH_EXPLAIN'	=> 'Maksimal bredde på bilder og Flash-filer i signaturer. Sett til 0 for ubegrenset bredde.',
	'MAX_SIG_LENGTH'	=> 'Maksimal lengde på signaturer',
	'MAX_SIG_LENGTH_EXPLAIN'	=> 'Maksimalt antall tegn i signaturer.',
	'MAX_SIG_SMILIES'	=> 'Maksimalt antall smilies i signaturer',
	'MAX_SIG_SMILIES_EXPLAIN'	=> 'Maksimalt antall smilies tillatt i signaturer. Sett til 0 for ubegrenset antall.',
	'MAX_SIG_URLS'	=> 'Maksimalt antall linker i signaturer',
	'MAX_SIG_URLS_EXPLAIN'	=> 'Maksimalt antall linker i brukersignaturer. Sett til 0 for ubegrenset antall.',
	'ACP_REGISTER_SETTINGS_EXPLAIN'	=> 'Her kan du tilpasse registrerings- og profilrelaterte innstillinger.',
	'ACC_ACTIVATION'	=> 'Kontoaktivering',
	'ACC_ACTIVATION_EXPLAIN'	=> 'Bestemmer om brukere har øyeblikkelig adgang til forumet eller om det kreves en annen form for bekreftelse. Du kan også deaktivere muligheten for å registrere seg i forumet.',
	'ACC_ADMIN'	=> 'Av administrator',
	'ACC_DISABLE'	=> 'Deaktivert',
	'ACC_NONE'	=> 'Ingen',
	'ACC_USER'	=> 'Av bruker',
	'ALLOW_EMAIL_REUSE'	=> 'Tillat gjenbruk av e-postadresse',
	'ALLOW_EMAIL_REUSE_EXPLAIN'	=> 'Tillater at forskjellige brukere kan registrere seg med samme e-postadresse.',
	'COPPA'	=> 'COPPA',
	'COPPA_FAX'	=> 'COPPA-telefaxnummer',
	'COPPA_MAIL'	=> 'COPPA-e-postadresse',
	'COPPA_MAIL_EXPLAIN'	=> 'Angi e-postadressen til foresatte som kan sende COPPA-registreringsformularene.',
	'ENABLE_COPPA'	=> 'Aktiver COPPA-funksjonen',
	'ENABLE_COPPA_EXPLAIN'	=> 'For å overholde den amerikanske U.S. COPPA-lovgivningen, kreves brukere i forbindelse ved registreringen en erklæring om hvorvidt de er 13 år gsmle eller eldre. Hvis COPPA-funksjonen deaktiveres, vises ikke COPPA-spesifikke grupper.',
	'MAX_CHARS'	=> 'Maximalt',
	'MIN_CHARS'	=> 'Minimalt',
	'MIN_TIME_REG'	=> 'Korteste tallatte registreringstid',
	'MIN_TIME_REG_EXPLAIN'	=> 'Registreringsformularen kan først sendes inn etter dette antall sekunder.',
	'MIN_TIME_TERMS'	=> 'Korteste tillatte visning av registreringsbetingelsene',
	'MIN_TIME_TERMS_EXPLAIN'	=> 'Registreringsbetingelserne kan først aksepteres etter dette antall sekunder.',
	'NO_AUTH_PLUGIN'	=> 'Ingen passende autorisasjonsmodul ble funnet.',
	'PASSWORD_LENGTH'	=> 'Passordlengde',
	'PASSWORD_LENGTH_EXPLAIN'	=> 'Minimalt og maksimalt antall tegn i passord.',
	'REG_LIMIT'	=> 'Antall tillatte egistreringsforsøk',
	'REG_LIMIT_EXPLAIN'	=> 'Antall registreringsforsøk brukere har før de utelukkes for den gjeldende sesjonen.',
	'USERNAME_ALPHA_ONLY'	=> 'Kun bokstaver og sifre',
	'USERNAME_ALPHA_SPACERS'	=> 'Bokstaver, sifre og mellomromstegn',
	'USERNAME_ASCII'	=> 'ASCII (ingen internasjonal unicode)',
	'USERNAME_LETTER_NUM'	=> 'Alle bokstaver og sifre',
	'USERNAME_LETTER_NUM_SPACERS'	=> 'Alle bokstaver, sifre og mellomromstegn',
	'USERNAME_CHARS'	=> 'Begrens brukbare tegn i brukernavn',
	'USERNAME_CHARS_ANY'	=> 'Alle tegn',
	'USERNAME_CHARS_EXPLAIN'	=> 'Begrens typen tegn som kan brukes i brukernavnet. Mellomromstegn er: mellomrom, -, +, _, [ og ].',
	'USERNAME_LENGTH'	=> 'Brukernavnlengde',
	'USERNAME_LENGTH_EXPLAIN'	=> 'Minimalt og maksimalt antall tegn i brukernavnet.',
	'ACP_VC_SETTINGS_EXPLAIN'	=> 'Her kan du tilpasse standardinnstillinger for visuell bekreftelse og CAPTCHA.',
	'CAPTCHA_GD'	=> 'GD CAPTCHA',
	'CAPTCHA_GD_FOREGROUND_NOISE'	=> 'Forgrunnsstøy i GD CAPTCHA',
	'CAPTCHA_GD_EXPLAIN'	=> 'Bruk GD hvis du ønsker en mer avanseret CAPTCHA.',
	'CAPTCHA_GD_FOREGROUND_NOISE_EXPLAIN'	=> 'Bruk forgrunnsstøy for å gjøre den GD-baserte CAPTCHA vanskeligere å lese.',
	'CAPTCHA_GD_X_GRID'	=> 'Bakgrunnsstøy i GD CAPTHAs x-akse',
	'CAPTCHA_GD_X_GRID_EXPLAIN'	=> 'En lavere innstilling her gjør den GD-baserte CAPTCHA vanskeligere å lese. 0 deaktiverer bakgrunnsstøy i x-aksen.',
	'CAPTCHA_GD_Y_GRID'	=> 'Bakgrunnsstøy i GD CAPTHAs y-akse',
	'CAPTCHA_GD_Y_GRID_EXPLAIN'	=> 'En lavere innstilling her gjør den GD-baserede CAPTCHA vanskeligere å lese. 0 deaktiverer bakgrunnsstøy i y-aksen.',
	
	'CAPTCHA_GD_WAVE'                  => 'GD CAPTCHA bølgefordreiing',
	'CAPTCHA_GD_WAVE_EXPLAIN'            => 'Gir CAPTCHA-en en bølgefordreiing.',
	'CAPTCHA_GD_3D_NOISE'               => 'Legg til 3D-støyobjekter',
	'CAPTCHA_GD_3D_NOISE_EXPLAIN'         => 'Legger til objekter over bokstavene på CAPTCHA-en.',
	'CAPTCHA_GD_FONTS'                  => 'Bruk forskjellige skrifttyper',
	'CAPTCHA_GD_FONTS_EXPLAIN'            => 'Denne innstillingen kontrollerer hvor mange forskjellige skrifttyper som skal brukes. Du kan bruke standardformene eller introdusere andre bokstaver. Det er også mulig å legge til små bokstaver.',
	'CAPTCHA_FONT_DEFAULT'               => 'Standard',
	'CAPTCHA_FONT_NEW'                  => 'Nye former',
	'CAPTCHA_FONT_LOWER'               => 'Bruk også små bokstaver',
   
	'CAPTCHA_PREVIEW_MSG'	=> 'Dine endringer i innstillingene er ikke lagret. Visningen er kun en prøve.',
	'CAPTCHA_PREVIEW_EXPLAIN'	=> 'CAPTCHA-funksjonen vises med de nåværende innstillinger. Bruk knappen "Forhåndsvis" for å oppdatere. Merk deg at CAPTCHAs vises tilfeldig og varierer fra den ene visningen til den neste.',
	'VISUAL_CONFIRM_POST'	=> 'Aktiver visuell bekreftelse for innlegg fra gjester',
	'VISUAL_CONFIRM_POST_EXPLAIN'	=> 'Krever at gjester (ikke registrerte brukere) skriver inn en kode som tilsvarer tilfeldige tegn på et bilde for å forhindre automatisk spamming og skriving av masseinnlegg.',
	'VISUAL_CONFIRM_REG'	=> 'Aktiver visuell bekreftelse for registreringer',
	'VISUAL_CONFIRM_REG_EXPLAIN'	=> 'Krever at nye brukere skriver inn en kode som tilsvarer tilfeldige tegn på et bilde for å forhindre automatisk masseregistrering.',
	
   'VISUAL_CONFIRM_REFRESH'            => 'Tillat brukere å oppdatere bekreftelsesbildet',
   'VISUAL_CONFIRM_REFRESH_EXPLAIN'      => 'Tillater brukere å bruke andre bekreftelseskoder hvis de ikke kan lese den gjeldende koden under registreringen.',
   
	'ACP_COOKIE_SETTINGS_EXPLAIN'	=> 'Disse innstillingene definerer data brukt til å sende informasjonskapsler til brukernes nettlesere. I de fleste tilfeller skal standardverdierne for informasjonskapselsinnstillinger være tilstrekkelige. Hvis du har behov for å endre noen av innstillingene, gjør det med forsiktighet, da gale innstillinger kan forhindre brukerne i å logge seg inn.',
	'COOKIE_DOMAIN'	=> 'Informasjonskapseldomene',
	'COOKIE_NAME'	=> 'Informasjonskapselnavn',
	'COOKIE_PATH'	=> 'Informasjonskapselsti',
	'COOKIE_SECURE'	=> 'SSL-sikkerhet',
	'COOKIE_SECURE_EXPLAIN'	=> 'Hvis serveren kjører via SSL, aktiver dette, ellers la det være deaktivert. Hvis dette er aktivert på et domene som ikke kjører SSL, vil det resultere i serverfeil ved videre innstillinger.',
	'ONLINE_LENGTH'	=> 'Varighet av onlineinformasjonen',
	'ONLINE_LENGTH_EXPLAIN'	=> 'Antall minutter det skal gå før en bruker mister påloggetstatusen. Jo større tidsrom, desto lengre behandlingstid brukes for å generere listen.',
	'SESSION_LENGTH'	=> 'Sesjonslengde.',
	'SESSION_LENGTH_EXPLAIN'	=> 'Sesjoner vil utløpe etter dette antall sekunder.',
	'ACP_LOAD_SETTINGS_EXPLAIN'	=> 'Her kan du deaktivere visse forumfunksjoner for å redusere forumets belastning av serveren. På de fleste servere skal det ikke være nødvendig å gjøre det, men på noen systemer eller i delte webhoteller kan det være en fordel. Du kan også angi begrensninger for systembelastning og aktive sesjoner.',
	'CUSTOM_PROFILE_FIELDS'	=> 'Tilpassede profilfelter',
	'LIMIT_LOAD'	=> 'Begrens systembelastning',
	'LIMIT_LOAD_EXPLAIN'	=> 'Hvis systembelastningen i gjennomsnitt over 1 minutt overskrider denne verdien, vil forumet gå offline. 1.0 er lik ~100% belastning av en prosessor. Dette virker kun på UNIX-baserte servere og hvor denne informasjonen er tilgjengelig. Verdien nullstiller seg selv hvis phpBB ikke er i stand til å finne belastningsgrensen.',
	'LIMIT_SESSIONS'	=> 'Begrens sesjoner',
	'LIMIT_SESSIONS_EXPLAIN'	=> 'Hvis antallet av sesjoner overskrider denne verdien innenfor 1 minutt, vil forumet gå offline. Sett til 0 for ubegrenset antall.',
	'LOAD_CPF_MEMBERLIST'	=> 'Tillat forumdesignet å tilpasses på profilfelter i medlemslisten.',
	'LOAD_CPF_VIEWPROFILE'	=> 'Vis tilpassede profilfelter i brukerprofiler',
	'LOAD_CPF_VIEWTOPIC'	=> 'Vis tilpassede profilfelter på emnesider',
	'LOAD_USER_ACTIVITY'	=> 'Vis brukers aktivitet',
	'LOAD_USER_ACTIVITY_EXPLAIN'	=> 'Viser aktivt emne og forum i brukerprofiler og brukerkontrollpanel. Det anbefales å deaktivere dette for forum med mer enn en million innlegg.',
	'RECOMPILE_STYLES'	=> 'Rekompiler fastfrosne forumdesign',
	'RECOMPILE_STYLES_EXPLAIN'	=> 'Kontrollerer og rekompilerer oppdaterte forumdesignkomponenter i filsystemet.',
	'YES_ANON_READ_MARKING'	=> 'Aktiver emnemarkering for gjester',
	'YES_ANON_READ_MARKING_EXPLAIN'	=> 'Lagrer lest-/uleststatusinformasjonen for gjester. Hvis deaktivert, vises innlegg alltid som leste for gjester.',
	'YES_BIRTHDAYS'	=> 'Aktiver bursdagslisten',
	'YES_BIRTHDAYS_EXPLAIN'	=> 'Hvis deaktivert, vises ikke bursdagslisten på hovedsiden. For å aktivere visning av listen, forutsetter det at visning av bursdag også er valgt under forumsinnstillingene.',
	'YES_JUMPBOX'	=> 'Aktiver visning av hopp-til-boks (Jumpbox)',
	'YES_MODERATORS'	=> 'Aktiver visning av moderatorer',
	'YES_ONLINE'	=> 'Aktiver påloggetstatus for registrerte brukere',
	'YES_ONLINE_EXPLAIN'	=> 'Viser påloggetstatus for registrerte brukere på hovedsiden, i forum og på emnesider.',
	'YES_ONLINE_GUESTS'	=> 'Aktiver onlinestatus for gjester',
	'YES_ONLINE_GUESTS_EXPLAIN'	=> 'Viser gjester under "Hvem er i forumet".',
	'YES_ONLINE_TRACK'	=> 'Aktiver på-/avloggetstatus for registrerte brukere',
	'YES_ONLINE_TRACK_EXPLAIN'	=> 'Viser på-/avloggetstatus for registrerte brukere i profiler og på emnesider.',
	'YES_POST_MARKING'	=> 'Aktiver markering av emner med egne innlegg',
	'YES_POST_MARKING_EXPLAIN'	=> 'Indikerer om brukeren har skrevet innlegg i et emne.',
	'YES_READ_MARKING'	=> 'Aktiver serversideemnemarkering',
	'YES_READ_MARKING_EXPLAIN'	=> 'Lagrer lest-/uleststatusinformasjon i databasen i stedet for i en informasjonskapsel.',
	'ACP_AUTH_SETTINGS_EXPLAIN'	=> 'phpBB støtter forskellige autentifikasjonsmoduler som gir mulighet for å bestemme hvordan en bruker skal autentifiseres ved innlogging på forumet. Det er tre standardmoduler med i phpBB: DB, LDAP og Apache. Ikke alle metodene krever ytterligere informasjon, fyll kun ut feltene hvis det er relevant til den valgte metoden.',
	'AUTH_METHOD'	=> 'Velg en autentifikasjonsmetode',
	'APACHE_SETUP_BEFORE_USE'	=> 'Du skal konfigurere autentifikasjon i Apache før du endrer phpBB til å bruke denne metoden. Husk at det anvendte brukernavn til autentifikasjonen skal være det samme som phpBB-brukernavnet ditt. Autentifikasjon i Apache kan kun benyttes med mod_php (ikke med en CGI-versjon) og med safe_mod deaktivert.',
	'LDAP_DN'	=> 'LDAP base <var>dn</var>',
	'LDAP_DN_EXPLAIN'	=> 'Dette er LDAP Distinguished Name, som angir brukerinformasjonen. Eksempel: <samp>o=mitt firma,c=no</samp>.',
	'LDAP_EMAIL'	=> 'LDAP e-mail attribute',
	'LDAP_EMAIL_EXPLAIN'	=> 'Sett denne til navnet på din brukertabells e-postattributt (hvis en slik eksisterer) for automatisk å sette e-postadressen for nye brukere. Ved å la dette feltet stå tomt, vil brukere ved første innlogging få tildelt en tom e-postadresse.',
	'LDAP_INCORRECT_USER_PASSWORD'	=> 'Forbindelse til LDAP-server mislyktes med det anvendte brukernavnet og passordet.',
	'LDAP_NO_EMAIL'	=> 'Det angitte e-postattributtet eksisterer ikke.',
	'LDAP_NO_IDENTITY'	=> 'Kunne ikke finne noen innloggingsidentitet for %s.',
	'LDAP_PASSWORD'	=> 'LDAP-passord',
	'LDAP_PASSWORD_EXPLAIN'	=> 'La stå tomt for å benytte anonym tilkobling, fylles ellers ut med ovenforstående brukers passord.  Kreves av Active Directory-servere. <strong>ADVARSEL:</strong> Passordet blir lagret i databasen i klar og ukryptert tekst, og vil være synlig for alle med adgang til databasen eller til denne konfigurasjonssiden.',
	'LDAP_PORT'	=> 'LDAP-serverport',
	'LDAP_PORT_EXPLAIN'	=> 'Hvis standardporten 389 ikke brukes når det kobles til LDAP-serveren, kan du her angi hvilken alternativ port phpBB skal bruke i stedet.',
	'LDAP_SERVER'	=> 'LDAP-servernavn',
	'LDAP_SERVER_EXPLAIN'	=> 'Ved bruk av LDAP, er dette navnet eller IP-adressen på LDAP-serveren. Alternativt kan du angi en URL, eksempelvis ldap://hostname:port/.',
	'LDAP_UID'	=> 'LDAP <var>uid</var>',
	'LDAP_UID_EXPLAIN'	=> 'Dette er den nøkkelen som det søkes etter på en gitt innlogging, for eksempel <var>uid</var>, <var>sn</var> osv.',
	'LDAP_USER'	=> 'LDAP user <var>dn</var>',
	'LDAP_USER_EXPLAIN'	=> 'La stå tomt for å benytte anonym tilkobling. Fylles feltet ut, vil phpBB bruke det angitte Distinguished Name (DN) ved innloggingsforsøk for å bestemme den korrekte bruker, f.eks. <samp>uid=Brukernavn,ou=MinAvdeling,o=MittFirma,c=NO</samp>. Kreves av Active Directory-servere.',
	'LDAP_USER_FILTER'	=> 'LDAP-brukerfilter',
	'LDAP_USER_FILTER_EXPLAIN'	=> 'Ved å benytte ytterligere filtre, har du mulighet til å begrense de objekter det søkes i. For eksempel vil <samp>objectClass=posixGroup</samp> bety at <samp>(&(uid=$username)(objectClass=posixGroup))</samp> skal benyttes.',
	'ACP_SERVER_SETTINGS_EXPLAIN'	=> 'Her kan du tilpasse server- og domeneavhengige innstillinger. Du bør forsikre deg at data er riktige, da feil vil resultere i feil e-postkontaktinformasjon. Vær oppmerksom på at oppgiving av domenenavn inkluderer http:// eller annen protokollangivelse. Rett portnummeret hvis du vet at serveren bruker en annen verdi (port 80 er korrekt i de fleste tilfeller).',
	'ENABLE_GZIP'	=> 'Aktiver GZip-komprimering',
	'ENABLE_GZIP_EXPLAIN'	=> 'Det genererte innholdet blir komprimert før sending til brukeren. Det kan bidra til å forminske nettverkstrafikken, og dermed også båndbreddeforbruket, men til gjengjeld økes belastningen av både serverens og brukerens CPU.',
	'FORCE_SERVER_VARS'	=> 'Force server-URL-innstillinger',
	'FORCE_SERVER_VARS_EXPLAIN'	=> 'Hvis denne er satt til ja, vil serverinnstillingene satt her bli brukt til de automatisk leste verdiene.',
	'ICONS_PATH'	=> 'Innleggsikonmappens plassering',
	'ICONS_PATH_EXPLAIN'	=> 'Sti fra phpBB-rotmappen, for eksempel <samp>images/icons/</samp>.',
	'PATH_SETTINGS'	=> 'Stiinnstillinger',
	'RANKS_PATH'	=> 'Rangeringsikonmappens plassering',
	'RANKS_PATH_EXPLAIN'	=> 'Sti fra phpBB-rotmappen, for eksempel <samp>images/ranks/</samp>.',
	'SCRIPT_PATH'	=> 'Sti til skriptet',
	'SCRIPT_PATH_EXPLAIN'	=> 'Sti til phpBB relativt i forhold til domenenavnet, eksempelvis <samp>phpBB3/</samp>.',
	'SERVER_NAME'	=> 'Domenenavn',
	'SERVER_NAME_EXPLAIN'	=> 'Domenenavnet forumet kjører på (eksempel: <samp>www.example.com</samp>).',
	'SERVER_PORT'	=> 'Serverport',
	'SERVER_PORT_EXPLAIN'	=> 'Port 80 brukes som standard for alle webservere. Innstillingen skal kun endres i helt spesielle tilfeller.',
	'SERVER_PROTOCOL'	=> 'Serverprotokoll',
	'SERVER_PROTOCOL_EXPLAIN'	=> 'Denne innstillingen kan settes til enten http:// eller https:// og er dermed fast definert. Hvis feltet ikke fylles ut, fastsettes protokollen ut fra sikkerhetsinnstillingene i informasjonskapsler (<samp>http://</samp> eller <samp>https://</samp>).',
	'SERVER_URL_SETTINGS'	=> 'Server-URL-innstillinger',
	'SMILIES_PATH'	=> 'Smilmappens plassering',
	'SMILIES_PATH_EXPLAIN'	=> 'Sti fra phpBB-rotmappen, for eksempel <samp>images/smilies/</samp>.',
	'UPLOAD_ICONS_PATH'	=> 'Filtypeikonmappens plassering',
	'UPLOAD_ICONS_PATH_EXPLAIN'	=> 'Sti fra phpBB-rotmappen, for eksempel <samp>images/upload_icons/</samp>.',
	'ACP_SECURITY_SETTINGS_EXPLAIN'	=> 'Her kan du tilpasse sesjons- og innloggingsrelaterte innstillinger.',
	'ALL'	=> 'Alle',
	'ALLOW_AUTOLOGIN'	=> 'Tillat autoinnlogging',
	'ALLOW_AUTOLOGIN_EXPLAIN'	=> 'Bestemmer om brukere kan logge seg inn automatisk når de besøker forumet.',
	'AUTOLOGIN_LENGTH'	=> 'Autoinnlogging utløper etter',
	'AUTOLOGIN_LENGTH_EXPLAIN'	=> 'Antall dager til autologginn utløper etter. Sett til 0 for å deaktivere.',
	'BROWSER_VALID'	=> 'Valider nettleser',
	'BROWSER_VALID_EXPLAIN'	=> 'Aktiverer nettleservalidering for hver sesjon, hvilket øker sikkerheten.',
	'CHECK_DNSBL'	=> 'Kontroller IP-adresser mot DNS blackhole-listen',
	'CHECK_DNSBL_EXPLAIN'	=> 'Hvis aktivert, blir brukerens IP-adresse kontrollert ved registrering og lagring av innlegg i følgende DNSBL services : <a href="http://spamcop.net/">spamcop.net</a>, <a href="http://dsbl.org/">dsbl.org</a> og <a href="http://www.spamhaus.org/">www.spamhaus.org</a>. Oppslaget kan ta litt tid, avhengig av serverkonfigurasjonen. Hvis kontrollen medfører for mange feilaktige avvisninger eller setter ned "ekspedisjonstiden", anbefales det å deaktivere kontrollen.',
	'CLASS_B'	=> 'A.B',
	'CLASS_C'	=> 'A.B.C',
	'EMAIL_CHECK_MX'	=> 'Kontroller om e-postdomenet har en gyldig MX-record',
	'EMAIL_CHECK_MX_EXPLAIN'	=> 'Hvis aktivert, vil e-postdomenet bli kontrollert for korrekt domeneregistrering og profilredigeringer for en gyldig MX-record.',
	'FORCE_PASS_CHANGE'	=> 'Påtving passordredigering',
	'FORCE_PASS_CHANGE_EXPLAIN'	=> 'Krever at brukeren skifter passord etter det innstillte antall dager. Settes verdien til 0 deaktiveres denne tvangsredigeringen.',
	'FORM_TIME_MAX'	=> 'Maksimal tid for å sende inn innlegg/meldinger',
	'FORM_TIME_MAX_EXPLAIN'	=> 'Tiden en bruker har til å sende inn et innlegg eller en melding. Sett til -1 for å deaktivere innstillingen. Vær oppmerksom på at et innlegg eller en melding kan bli ugyldig hvis sesjonen utløper uavhengig av denne innstillingen.',
	'FORM_TIME_MIN'	=> 'Minimal tid for å sende inn innlegg/meldinger',
	'FORM_TIME_MIN_EXPLAIN'	=> 'Sendes det inn raskere enn dette antall sekunder, ignoreres det av forumet. Sett til 0 for å deaktivere innstillingen.',
	'FORM_SID_GUESTS'	=> 'Knytt innlegg/meldinger til gjestesesjoner',
	'FORM_SID_GUESTS_EXPLAIN'	=> 'Hvis "Ja", vil innlegg/meldinger skrevet av gjester bli basert på enkeltsesjoner. Vær oppmerksom på at denne innstillingen kan gi problemer i forhold til noen webhoteller.',
	'FORWARDED_FOR_VALID'	=> 'Kontrollert <var>X_FORWARDED_FOR</var>-hode',
	'FORWARDED_FOR_VALID_EXPLAIN'	=> 'Sesjoner vil kun bli fortsatt hvis det sendte <var>X_FORWARDED_FOR</var>-hodet svarer til det som ble sendt med den forrige anmodningen. Utestengelser blir også kontrollert mot IP-adresser i <var>X_FORWARDED_FOR</var>.',
	'IP_VALID'	=> 'Validering av IP-adresser under sesjoner',
	'IP_VALID_EXPLAIN'	=> 'Avgjør hvor mye av brukerens IP-adresse, som brukes til å validere en sesjon; <samp>Alle</samp> sammenligner hele adressen, <samp>A.B.C</samp> de første x.x.x, <samp>A.B</samp> de første x.x og <samp>Ingen</samp> deaktiverer kontrollen. I IPv6 adresser de fire første blokkene ved <samp>A.B.C</samp> og de tre første ved <samp>A.B</samp>.',
	'MAX_LOGIN_ATTEMPTS'	=> 'Maksimalt antall innloggingsforsøk',
	'MAX_LOGIN_ATTEMPTS_EXPLAIN'	=> 'Etter dette antall mislykkede innloggingsforsøk, skal brukeren ytterligere bekrefte innloggingen visuelt (visuell bekreftelse).',
	'NO_IP_VALIDATION'	=> 'Ingen',
	'PASSWORD_TYPE'	=> 'Passordkompleksitet',
	'PASSWORD_TYPE_EXPLAIN'	=> 'Avgjør hvor komplekst et passord skal være når det innstilles eller endres. Etter følgende muligheter inneholder også de foranstående.',
	'PASS_TYPE_ALPHA'	=> 'Skal inneholde bokstaver og tall',
	'PASS_TYPE_ANY'	=> 'Ingen krav',
	'PASS_TYPE_CASE'	=> 'Skal være med både store og små bokstaver',
	'PASS_TYPE_SYMBOL'	=> 'Skal inneholde symboler',
	'TPL_ALLOW_PHP'	=> 'Tillat PHP i maler',
	'TPL_ALLOW_PHP_EXPLAIN'	=> 'Hvis denne innstillingen er aktivert, vil kommandoene <code>PHP</code> og <code>INCLUDEPHP</code> i templatefilene bli gjenkjent og behandlet.',
	'ACP_EMAIL_SETTINGS_EXPLAIN'	=> 'Disse innstillingene benyttes av forumet ved sending av e-post til registrerte brukere. Vær oppmerksom på at denne e-postadressen skal være gyldig, da enhver tilbakesendt eller bortkommet e-post sannsynligvis vil bli returnert til denne e-postadressen. Hvis wewbhotellet ikke lar deg bruke den innebygde (PHP-baserte) e-posttjenesten, kan du i stedet sende e-post direkte gjennom SMTP. Dette krever adressen på en passende server (spør om nødvendig webhotellet). Hvis serveren krever autentifikasjon (og kun hvis den gjør) angis det nødvendige brukernavn, passord og autentifikasjonsmetoden.',
	'ADMIN_EMAIL'	=> 'Returadresse for e-post',
	'ADMIN_EMAIL_EXPLAIN'	=> 'Denne e-postadressen brukes som returadresse for all e-post, det vil si e-postadressen for teknisk kontakt. Den brukes alltid som <samp>Return-Path</samp>- og <samp>Sender</samp>-adressen i e-post.',
	'BOARD_EMAIL_FORM'	=> 'Aktiver sending av e-post via forumet',
	'BOARD_EMAIL_FORM_EXPLAIN'	=> 'I stedet for å vise brukerens e-postadresse, kan brukerne sende e-post via forumet.',
	'BOARD_HIDE_EMAILS'	=> 'Skjul e-postadresser',
	'BOARD_HIDE_EMAILS_EXPLAIN'	=> 'Denne funksjonen holder e-postadresser helt private.',
	'CONTACT_EMAIL'	=> 'Kontakte-postadresse',
	'CONTACT_EMAIL_EXPLAIN'	=> 'Denne e-postadressen brukes overalt hvor det er spesifikke kontaktpunkter, for eksempel i spam, feilmeldinger, problemer med registrering osv. Den vil alltid bli brukt som <samp>From</samp>- og <samp>Reply-To</samp>-adressene i e-post.',
	'EMAIL_FUNCTION_NAME'	=> 'Navn på e-postfunksjon',
	'EMAIL_FUNCTION_NAME_EXPLAIN'	=> 'Navnet på den e-postfunksjonen som benyttes ved sending av e-post gjennom PHP.',
	'EMAIL_PACKAGE_SIZE'	=> 'Pakkestørrelse for e-post',
	'EMAIL_PACKAGE_SIZE_EXPLAIN'	=> 'Antallet e-post som sendes i en pakke. Innstillingen legges til i den interne meldingskøen. Sett innstillingen til 0 hvis du opplever problemer med ikke avleverete adviseringse-poster.',
	'EMAIL_SIG'	=> 'E-postsignatur',
	'EMAIL_SIG_EXPLAIN'	=> 'Denne teksten brukes som signatur i all e-post som blir sendt ut fra forumet.',
	'ENABLE_EMAIL'	=> 'Aktiver forumets e-postsystem',
	'ENABLE_EMAIL_EXPLAIN'	=> 'Hvis deaktivert, vil ikke forumet sende noen e-post i det hele tatt.',
	'SMTP_AUTH_METHOD'	=> 'Autentifikasjonsmetode for SMTP',
	'SMTP_AUTH_METHOD_EXPLAIN'	=> 'Brukes kun hvis et brukernavn og passord er angitt. Spør webhotellet hvis du er usikker på hvilken metode som skal brukes.',
	'SMTP_CRAM_MD5'	=> 'CRAM-MD5',
	'SMTP_DIGEST_MD5'	=> 'DIGEST-MD5',
	'SMTP_LOGIN'	=> 'Innlogging',
	'SMTP_PASSWORD'	=> 'SMTP-passord',
	'SMTP_PASSWORD_EXPLAIN'	=> 'Skriv inn et passord bare hvis din SMTP-server krever det. <em><strong>Advarsel:</strong> Dette passordet lagres som ren tekst i databasen.</em>',
	'SMTP_PLAIN'	=> 'PLAIN',
	'SMTP_POP_BEFORE_SMTP'	=> 'POP-BEFORE-SMTP',
	'SMTP_PORT'	=> 'SMTP-serverport',
	'SMTP_PORT_EXPLAIN'	=> 'Rediger denne kun hvis du vet at SMTP-serveren benytter en annen port.',
	'SMTP_SERVER'	=> 'SMTP-serveradresse',
	'SMTP_SETTINGS'	=> 'SMTP-innstillinger',
	'SMTP_USERNAME'	=> 'SMTP-brukernavn',
	'SMTP_USERNAME_EXPLAIN'	=> 'Skriv inn et brukernavn kun hvis SMTP-serveren krever det.',
	'USE_SMTP'	=> 'Bruk SMTP-server for e-post',
	'USE_SMTP_EXPLAIN'	=> 'Velg "Ja" hvis du skal bruke en navngitt server til å sende e-post i stedet for å bruke forumets innebygde e-postfunksjon.',
	'ACP_JABBER_SETTINGS_EXPLAIN'	=> 'Herfra kan du aktivere og administrere bruken av Jabber til å fremsende adviseringer om nye private meldinger og ved oppdateringer i overvåkede emner og forum. Jabber er en åpen kildekode-protokoll og kan derfor benyttes av enhver. Noen Jabber-servere inkluderer gateways eller transporter, som tillater deg å kontakte brukere av andre nettverk. Ikke alle servere tilbyr alle former for transporter, og redigeringer i protokoller kan forhindre transporter i å fungere. Oppgi her nøyaktig til det formålet en opprettet Jabberkonto og phpBB gjør bruk av disse data.',
	'JAB_ENABLE'	=> 'Aktiver Jabber',
	'JAB_ENABLE_EXPLAIN'	=> 'Aktiverer bruken av meldinger og adviseringer via Jabber.',
	'JAB_GTALK_NOTE'	=> 'Funksjonen <samp>dns_get_record</samp> ble ikke funnet, og bruk av GTalk fungerer derfor ikke. <samp>dns_get_record</samp> er ikke tilgjenglig i PHP4 og ikke implementert på Windowsplattformene. Den fungerer i øyeblikket heller ikke på BSD-baserte systemer, som også inkluderer Mac OS.',
	'JAB_PACKAGE_SIZE'	=> 'Pakkestørrelse for Jabber',
	'JAB_PACKAGE_SIZE_EXPLAIN'	=> 'Dette er antall meldinger sendt i en pakke. Hvis denne er satt til 0, sendes meldingen øyeblikkelig og settes ikke i kø til senere sending.',
	'JAB_PASSWORD'	=> 'Jabber-passord',
	'JAB_PASSWORD_EXPLAIN'		=> '<em><strong>Advarsel:</strong> Dette passordet lagres som ren tekst i databasen.</em>',
	'JAB_PORT'	=> 'Jabber-port',
	'JAB_PORT_EXPLAIN'	=> 'Fylles ikke ut, med mindre det ikke er port 5222.',
	'JAB_SERVER'	=> 'Jabber server',
	'JAB_SERVER_EXPLAIN'	=> 'Se %sjabber.org%s for en liste over servere.',
	'JAB_SETTINGS_CHANGED'	=> 'Jabberinnstillingene er korrekt oppdatert.',
	'JAB_USE_SSL'	=> 'Bruk SSL for tilkobling',
	'JAB_USE_SSL_EXPLAIN'	=> 'En sikker forbindelse forsøkes etablert. Den benyttede Jabber-porten blir endret til 5223 hvis port 5222 er angitt.',
	'JAB_USERNAME'	=> 'Jabber-brukernavn',
	'JAB_USERNAME_EXPLAIN'	=> 'Angi en allerede opprettet Jabber-konto. Navnets gyldighet kontrolleres ikke av phpBB.',
	
	'NO_REF_VALIDATION'				=> 'Ingen',
	'REF_HOST'						=> 'Valider kun host',
	'REF_PATH'						=> 'Valider sti også',
	'REFERER_VALID'					=> 'Valider verver',
	'REFERER_VALID_EXPLAIN'			=> 'Hvis aktivert, vil ververen av POST-forespørsler bli sjekket mot stiinnstillingene til hosten/skriptet. Dette kan forårsake problemer med forum som benytter flere domener og/eller eksterne innloggingsskjemaer.',
	
	'ALLOW_MASS_PM_EXPLAIN'		=> 'Sending til grupper kan bli justert i den enkelte gruppe på gruppeinnstillingssiden.',
	'PM_MAX_RECIPIENTS'			=> 'Maksimalt tillatt antall mottakere',
	'PM_MAX_RECIPIENTS_EXPLAIN'	=> 'Det maksimale antallet mottakere av en privat melding. Hvis 0 er oppgitt, er dette antallet ubegrenset. Denne innstillingen kan bli justert for enkeltgrupper på gruppeinnstillingssiden.',
	'ENABLE_QUEUE_TRIGGER'			=> 'Aktiver postkø',
	'ENABLE_QUEUE_TRIGGER_EXPLAIN'	=> 'Mulighet til å sette registrerte brukeres innlegg til godkjenning dersom deres innleggsantall er lavere enn det oppgitte tallet. Denne innstillingen har ingen effekt på rettighetsinnstillingen for godkjenning av innlegg.',
	'QUEUE_TRIGGER_POSTS'			=> 'Maksimalt antall innlegg for brukere med køpost',
	'QUEUE_TRIGGER_POSTS_EXPLAIN'	=> 'Hvis postkø er aktivert, er dette antallet innlegg brukeren trenger for å kunne poste uten godkjenning. Er brukerens innleggsantall lavere enn dette tallet, blir innlegget automatisk lagt i kø.',
	
	'ALLOW_PM_REPORT'			=> 'Tillat brukere å rapportere private meldinger',
	'ALLOW_PM_REPORT_EXPLAIN'	=> 'Hvis denne innstillingen er aktivert, vil brukere ha mulighet til å rapportere en privat melding de har mottatt eller sendt til forumets moderatorer. Disse private meldingene vil da bli synlige i moderatorkontrollpanelet.',
	'ALLOW_QUICK_REPLY'			=> 'Tillat hurtigsvar',
	'ALLOW_QUICK_REPLY_EXPLAIN'	=> 'Denne innstillingen bestemmer om hurtigsvar er aktivert eller ikke. Hvis denne innstillingen er aktivert, må forumenes hurtigsvaralternativ også være aktivert.',
	'ALLOW_QUICK_REPLY_BUTTON'	=> 'Lagre og aktiver hurtigsvar i alle forum',
	'ALLOW_AVATARS'					=> 'Tillat avatarer',
	'ALLOW_AVATARS_EXPLAIN'			=> 'Tillat generell bruk av avatarer;<br/>Hvis du deaktiverer generelle avatarer eller avatarer med spesielle innstillinger, vil de deaktiverte avatarene ikke lenger bli vist i forumet, men brukerne vil fortsatt kunne laste ned deres egne avatarer i brukerkontrollpanelet.',
	'ALLOW_REMOTE_UPLOAD'			=> 'Tillat fjernopplasting av avatarer',
	'ALLOW_REMOTE_UPLOAD_EXPLAIN'	=> 'Tillat opplasting av avatarer fra et annet nettsted.',
	'DELETE_TIME'					=> 'Slettetidsgrense',
	'DELETE_TIME_EXPLAIN'			=> 'Tiden som kan gå før man sletter et nytt innlegg. Sett til 0 for å deaktivere denne funksjonen.',
	'MIN_CHAR_LIMIT'				=> 'Minimum tegn per innlegg/melding',
	'MIN_CHAR_LIMIT_EXPLAIN'		=> 'Minimum antall tegn brukeren kan bruke i et innelegg/privat melding.',
	'SMILIES_PER_PAGE'				=> 'Smilefjes per side',
	'NEW_MEMBER_POST_LIMIT'			=> 'Innleggsgrense nye brukere',
	'NEW_MEMBER_POST_LIMIT_EXPLAIN'	=> 'Nye medlemmer er innenfor gruppe <em>Nylig registrerte brukere </em> før de når dette antallet innlegg. Du kan bruke denne gruppen til å forby dem å bruke PM-systemet eller å gjennomgå sine poster. <strong>Verdien 0 deaktiverer denne funksjonen.</strong>',
	'NEW_MEMBER_GROUP_DEFAULT'		=> 'Sett gruppen Nylig registrerte brukere til standard',
	'NEW_MEMBER_GROUP_DEFAULT_EXPLAIN'	=> 'Hvis satt til ja og nytt medlem-innleggsgrensen er spesifisert, skal nylig registrerte brukere skal ikke bare settes i gruppen <em>Nylig registrerte brukere</em>, men denne gruppen også blir deres standard. Dette kan komme til nytte hvis du vil tilordne en gruppe standardrangering og/eller avatar som brukeren så arver.',
	'ACP_FEED_MANAGEMENT'				=> 'Generelle syndikeringsfeedinnstillinger',
	'ACP_FEED_MANAGEMENT_EXPLAIN'		=> 'Denne modulen tilgjengeliggjør ulike ATOM-feeder og konverterer BBCode i innleggene for å gjøre dem lesbare i eksterne feeds.',

	'ACP_FEED_GENERAL'					=> 'Generelle feed-innstillinger',
	'ACP_FEED_POST_BASED'				=> 'Innleggsbasert feed-innstillinger',
	'ACP_FEED_TOPIC_BASED'				=> 'Emnebasert feed-innstillinger',
	'ACP_FEED_SETTINGS_OTHER'			=> 'Andre feeder og innstillinger',

	'ACP_FEED_ENABLE'					=> 'Aktiver feeder',
	'ACP_FEED_ENABLE_EXPLAIN'			=> 'Aktiverer eller deaktiverer ATOM-feeder for hele forumet.<br/>Deaktivering dette deaktiverer alle feeds, uansett hvordan alternativene nedenfor er satt.',
	'ACP_FEED_LIMIT'					=> 'Antall elementer',
	'ACP_FEED_LIMIT_EXPLAIN'			=> 'Maks antall feedelementer å vise.',

	'ACP_FEED_OVERALL'					=> 'Aktiver global feed',
	'ACP_FEED_OVERALL_EXPLAIN'			=> 'Nye poster i hele forumet.',

	'ACP_FEED_OVERALL_FORUMS'			=> 'Aktiver feed for hovedforumene',
	'ACP_FEED_OVERALL_FORUMS_EXPLAIN'	=> 'Denne feeden viser de siste innleggene fra alle emnene.',
	'ACP_FEED_OVERALL_FORUMS_LIMIT'		=> 'Antall elementer per side å vise i forumfeeden',

	'ACP_FEED_OVERALL_TOPIC'			=> 'Aktiver feed for hovedemner',
	'ACP_FEED_OVERALL_TOPIC_EXPLAIN'	=> 'Akktiverer "Alle emner"-feeden',
	'ACP_FEED_OVERALL_TOPIC_LIMIT'		=> 'Antall elementer per side å vise i emnefeeden',
	'ACP_FEED_FORUM'					=> 'Aktiver Per-Forum-feeder',
	'ACP_FEED_FORUM_EXPLAIN'			=> 'Nye innlegg i forumene enkeltvis.',
	'ACP_FEED_TOPIC'					=> 'Aktiver enkeltemnefeeder',
	'ACP_FEED_TOPIC_EXPLAIN'			=> 'Nye innlegg i emnene enkeltvis.',

	'ACP_FEED_TOPICS_NEW'				=> 'Aktiver feed med nye emner',
	'ACP_FEED_TOPICS_NEW_EXPLAIN'		=> 'Aktiverer "Nye emner"-feeden, som viser de sist opprettede emnene inkludert det første innlegget.',
	'ACP_FEED_TOPICS_ACTIVE'			=> 'Aktiver feed med aktive emner',
	'ACP_FEED_TOPICS_ACTIVE_EXPLAIN'	=> 'Aktiverer "Aktive emner"-feeden, som viser de sist aktive emnene inkludert det første innlegget.',
	'ACP_FEED_NEWS'						=> 'Nyhetsfeeder',
	'ACP_FEED_NEWS_EXPLAIN'				=> 'Dra det første innlegget fra disse forumene. Velg ingen forum for å deaktivere nyhetsfeeden.<br/>Velg flere forum ved å holde nede <samp>CTRL</samp> og klikke.',

	'ACP_FEED_HTTP_AUTH'				=> 'Tillat HTTP-godkjenning',
	'ACP_FEED_HTTP_AUTH_EXPLAIN'		=> 'Aktiverer HTTP-godkjenning, som tillater brukere å motta innhold som er skjult for gjestenes brukere ved å legge til <samp>auth=http</samp>-parameteret i feed-URL-en. Vær oppmerksom på at enkelte PHP-oppsett krever ytterligere endringer i .htaccess-filen. Instruksjoner finner du i denne filen.',

	'ACP_FEED_GENERAL'					=> 'Generelle feedinnstillinger',

	'ACP_FEED_ITEM_STATISTICS'			=> 'Elementstatistikk',
	'ACP_FEED_ITEM_STATISTICS_EXPLAIN'	=> 'Vis individuell statistikk under feedelementene<br/>(publisert av, dato og tid, svar, visninger)',
	'ACP_FEED_EXCLUDE_ID'				=> 'Ekskluder disse forumene',
	'ACP_FEED_EXCLUDE_ID_EXPLAIN'		=> 'Innhold fra disse vil <strong>ikke bli inkludert i feeder</strong>. Ikke velg noen forum for å trekke data fra alle forum.<br />Marker/demarker flere forum ved å holde nede <samp>CTRL</samp> og klikke.',
	'AVAILABLE_CAPTCHAS'					=> 'Tilgjengelige utvidelser',
	'CAPTCHA_UNAVAILABLE'					=> 'Denne CAPTCHA-en kan ikke brukes fordi kravene dens ikke er oppfylt.',
	'CAPTCHA_GD_3D'							=> 'GD 3D Captcha',
	'CAPTCHA_NO_GD'							=> 'CAPTCHA uten GD',
	'CAPTCHA_SELECT'						=> 'Installerte CAPTCHA-utvidelser',
	'CAPTCHA_SELECT_EXPLAIN'				=> 'Nedtrekksboksen holder CAPTCHA-utvidelsene rekognisert av forumet. Grå oppføringer er ikke tilgjengelige akkurat nå og må kanskje konfigureres før bruk.',
	'CAPTCHA_CONFIGURE'						=> 'Konfigurer CAPTCHA-er',
	'CAPTCHA_CONFIGURE_EXPLAIN'				=> 'Endre innstillinger for den valgte CAPTCHA-en.',
	'CONFIGURE'								=> 'Konfigurer',
	'CAPTCHA_NO_OPTIONS'					=> 'Denne CAPTCHA-en har ingen konfigurasjonsmuligheter.'
));

?>