/***************************************************************************
                          phaseshift.h  -  description
                             -------------------
    begin                : Sat Sep 18 12:08:54 EDT 1999
    copyright            : (C) 1999 by Edson Pereira
    email                : edson_pereira@harvard.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef PHASESHIFT_H
#define PHASESHIFT_H

#define WF_SIZE 200
#define WF_HEIGHT 56

#define UDP_PORT 3700
#define MSG_DONTWAIT      0x40

#define SAMPLESLEN 8000

#define PTT_ON  TIOCMBIS
#define PTT_OFF TIOCMBIC

// include files for QT
#include <qpopupmenu.h>
#include <qmainwindow.h>
#include <qaccel.h>
#include <qmenubar.h>
#include <qtoolbar.h>
#include <qpixmap.h>
#include <qtoolbutton.h>
#include <qapp.h>
#include <qstatusbar.h>
#include <qwhatsthis.h>
#include <qmsgbox.h>
#include <qfiledialog.h>
#include <qprinter.h>
#include <qpainter.h>
#include <qlistbox.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qmultilinedit.h>
#include <qslider.h>
#include <qspinbox.h>
#include <qlineedit.h>
#include <qframe.h>

// application specific includes
#include "resource.h"
#include "phasescope.h"
#include "psk31receiver.h"
#include "psk31transmitter.h"
#include "masterdisplay.h"
#include "mixer.h"
#include "fftengine.h"
#include "spectrumframe.h"

/**
  * This Class is the base class for your application. It sets up the main
  * window and providing a menubar, toolbar
  * and statusbar. For the main view, an instance of class PhaseShiftView is
  * created which creates your view.
  */
class PhaseShift : public QMainWindow
{
  Q_OBJECT
  
public:
  /** construtor */
  PhaseShift(); 
  /** destructor */
  ~PhaseShift();
  /** initMenuBar creates the menu_bar and inserts the menuitems */
  void initMenuBar();
  /** this creates the toolbars. Change the toobar look and add new toolbars in this
   * function */
  void initToolBar();
  /** setup the statusbar */
  void initStatusBar();
  /** setup the main window */
  void initMainWindow();
  /** setup the document*/
  //void initDoc();
  /** setup the mainview*/
  void initView();
  
  /** overloaded for Message box on last window exit */
  bool queryExit();
  /** Read the configuration file .phaseshift in the users's home directory */
  void readConfig();

public slots:
  
  /** switch argument for Statusbar help entries on slot selection */
  void statusCallback(int id_);
  /** generate a new document in the actual view */
  //void slotFileNew();
  /** open a document */
  void slotFileOpen();
  /** save a document */
  void slotFileSave();
  /** save a document under a different filename*/
  void slotFileSaveAs();
  /** close the actual file */
  void slotFileClose();
  /** print the actual file */
  void slotFilePrint();
  /** exits the application */
  void slotFileQuit();
  /** put the marked text/object into the clipboard and remove
   * it from the document */
  void slotEditCut();
  /** put the marked text/object into the clipboard*/
  void slotEditCopy();
  /** paste the clipboard into the document*/
  void slotEditPaste();
  /** toggle the toolbar*/
  void slotPrependCallsign();
  /** shows an about dlg*/
  void slotHelpAbout();
  /** tunes the transmitter */
  void slotTune();
  /** sets the mode to BPSK */
  void slotBPSK();
  /** sets the mode to QPSK */
  void slotQPSK();
  /** toggles the AFC on/off */
  void slotAFC();
  /** toggles the DCD on/off */
  void slotDCD();
  /** toggles the NET on/off */
  void slotNET();
  /** Turns BEACON on */
  void slotBEACON();
  /** change the status message of the whole statusbar temporary */
  void slotStatusHelpMsg(const char *text);
  /** main processing routine */
  void process();
  void drawSpectrum();
  /** sets the rx frequency - value is in reverse form ( 0 -> 2000, 2000 -> 0 ) */
  void setRxFreq( int );
  /**  */
  void calculateIntermod();
  /** Called whenever a text change occurs in the tx text area */
  void txTextCallback( const char );
  /**  */
  void slotTypeAhead();
  void slotSquelchLevel( int );
  /**  */
  void setTx( bool tx );
  /** Called whenever a return is pressed in the tx text area #1 */
  void txReturnPressedCallback();
  /** Called whenever return is pressed on txLine #2 */
  void txLineCallback( );
  /** Called whenever the CQ push button is pressed */
  void slotCQ();
  /** Called whenever an item is selected on the marco list */
  void slotListItemSelected( int );
  /** Called when the beacon timer expires */
  void doBeacon();
  /**  */
  void processTxSample( short );
  /** Called periodically when a file is sent */
  void sendFile();
  /**  */
  void slotTxStop();
  /** Set Rx frequency */
  void setFreq( float );
  /** Toggles the break-in operation */
  void slotVox();


signals:

	void signalAngle( int, int, int );

  	/** Sends the frequency signal */
  	void signalFreq( float );
  	
  	/** Sends a signal when a character is received */
  	void signalRxChar( const char * );

protected:
	void resizeEvent( QResizeEvent * );

private:

  void rxText( int c );
  inline void PhaseShift::processSample( short sample )
  {
    static int i = 0;

    samples[ i++ ] = abs(sample);
    if ( i > SAMPLESLEN ) i = 0;
  }

  short samples[ SAMPLESLEN ];
  double computePower( void );
  /**  */
  void doPTT( int state );


  /** file_menu contains all items of the menubar entry "File" */
  QPopupMenu *file_menu;
  /** edit_menu contains all items of the menubar entry "Edit" */
  QPopupMenu *edit_menu;
  /** view_menu contains all items of the menubar entry "Options" */
  QPopupMenu *options_menu;
  /** view_menu contains all items of the menubar entry "Help" */
  QPopupMenu *help_menu;
  
  QToolBar *file_toolbar;

  SoundMixer* mixer;

  QLabel* divider1;
  QListBox* macroList;
  /** the txLine is where commands and text are entered */
    QLineEdit* txLine, *txLine1, *txLine2;
    QLineEdit* rxLine;
    SpectrumFrame* spectrumDisplay;
	QPushButton* cqPushButton, *txPushButton;
	PhaseScope* phaseScope;
	MasterDisplay* masterDisplay;
    FftEngine* fftEngine;
    Psk31Receiver psk31rx;
    psk31_transmitter psk31tx;

	char sound_device[80];
    int audio_fd;
    int transmit;
	int noiselevel;
    int afcFlag;
	int dcdFlag;
	int qpskFlag;
	int lsbFlag;
	int netFlag;
	int squelchlevel;
	int full_duplex;
	float rxFreq;
	float txFreq;
	int soundInputLevel;
    int soundOutputLevel;
    int soundPcmLevel;
	char macro[50][255];
    int numMacros;
	char callsign[40];
	int intermodFlag;
    int intermodLevel;
    int typeAheadFlag;
    int confidenceLevel;
    float snr; // signal to noise ratio of the received signal
    int standard_size;
    char beaconText[256];
    int beaconInterval;
    bool beaconFlag;
    bool logOpen;
    char logDir[128];
    FILE *logFile;
    char pttDevice[128];
    int sendingFileFlag;
    int bytesSent;
    FILE *send_fp;
    bool voxFlag;
    bool prependCallsignFlag;

};
#endif 
