# $Progeny: bootloader-ia64.py,v 1.17 2002/02/11 06:09:24 epg Exp $

import sys
import os
import re
import pgi.common
import parted

from pgi.common import _, TRUE, FALSE

LIVE = pgi.common.get_live()
LOGFILE = pgi.common.get_logfile()

def _mark_efi(device):
    parted.init()
    parted.device_probe_all()

    for dev in parted.get_devices():
        path = dev.get_path()

        disk = dev.disk_open()
        if not disk:
            pgi.common.warn(_("Could not read partition table from %s\n")
                            % (path,))
            return FALSE

        for part in disk.get_part_list():
            minor = part.get_num()
            if minor != -1 and part.get_type() != parted.PARTITION_EXTENDED:
                partname = "%s%d" % (path, minor)
                if device == partname:
                    r = part.mark_efi()
                    if r == -1 or r == FALSE:
                        return FALSE
                    else:
                        disk.write()
                        disk.close()
                        parted.done()
                        return TRUE

def install(device, root, target, mark_efi=FALSE):
    if mark_efi:
        # Mark the boot partition as EFI
        if not _mark_efi(device):
            return FALSE

    # Get the disk device and partition number.
    diskdev = re.split(r'\d+', device)[0]
    partnum_match = re.search(r'(\d+)$', device)
    if partnum_match:
        partnum = int(partnum_match.group(1))
    else:
        partnum = 1

    # Get the list of kernels and set up the most recent one.
    kernels = []
    for file in os.listdir("%s/boot" % (target,)):
        if file[:6] == "vmlinu":
            kernels.append(file)

    kernels.sort()
    kernels.reverse()

    kernel = kernels[0]

    # Copy kernel to /boot/efi.
    pgi.common.msg("Running cp %s/boot/%s %s/boot/efi/linux.\n" % (target, kernel, target))
    os.system("cp %s/boot/%s %s/boot/efi/linux" % (target, kernel, target))

    # Copy elilo to /boot/efi.
    pgi.common.msg("Running cp %s/usr/lib/elilo/elilo.efi %s/boot/efi.\n" % (target, target))
    os.system("cp %s/usr/lib/elilo/elilo.efi %s/boot/efi" % (target, target))

    # Write an elilo.conf and startup.nsh.
    # XXX: No .nsh file for now; it's nonstandard.
##     startup = open("%s/boot/efi/foo.nsh" % (target,), "w")
##     startup.write("elilo\n")
##     startup.close()

    eliloconf = open("%s/boot/efi/elilo.conf" % (target,), "w")
    eliloconf.write("delay=20\n\n")
    for kernel in kernels:
        eliloconf.write("image=linux\n  label=linux\n  root=%s\n  read-only\n\n"
                        % (root,))
    eliloconf.close()

    # Set a boot parameter line with efibootmgr.
    command = "%s/bin/efibootmgr -c -d %s -p %d -L \"Debian GNU/Linux\" 2>&1 | tee -a %s" % (target, diskdev, partnum, LOGFILE)
    pgi.common.msg("Running %s\n" % (command,))
    os.system(command)

    return TRUE
