# $Progeny: bootloader-i386.py,v 1.9 2002/04/10 23:14:20 branden Exp $

import os
import re
import sys

import pgi.common

from pgi.common import TRUE

LIVE = pgi.common.get_live()
LOGFILE = pgi.common.get_logfile()

def _get_grub_device(device, device_map):
    diskdev = re.split("[0-9]+", device)[0]

    mapfile = open(device_map, "r")
    line = mapfile.readline()
    while line:
        (grubdev, dev, discard) = re.split("\s+", line)
        if dev == diskdev:
            break
        line = mapfile.readline()
    mapfile.close()

    device = re.sub("/dev/", "", device)
    part = re.split("[a-z]+", device)[1]

    if part:
        # Linux-style 1-indexed partition, Grub needs 0-indexed
        part = int(part) - 1
        return re.sub("\)$", ",%d)" % (part,), grubdev)
    else:
        return grubdev

def install(device, root, target):
    # Retarded grub-install(8) relies on df(1), so make /etc/mtab
    # contain the root fs.
    mtab = open("%s/etc/mtab" % (target,), "a")
    mtab.write("%s / ext2 rw 0 0\n" % (root,))
    mtab.close()

    if os.environ["PGIDEBUG"] == "noisy":
        debug_option = "-x"
    else:
        debug_option = ""

    pgi.common.msg("Running chroot %s sh %s /sbin/grub-install %s 2>&1 | tee -a %s.\n"
              % (target, debug_option, device, LOGFILE))
    os.system("chroot %s sh %s /sbin/grub-install %s 2>&1 | tee -a %s"
              % (target, debug_option, device, LOGFILE))

    device_map = "%s/boot/grub/device.map" % (target,)
    root_grubdevice = _get_grub_device(root, device_map)

    kopt = "# kopt=root=%s ro" % (root,)
    groot = "# groot=%s" % (root_grubdevice,)

    pgi.common.msg("Running echo y | chroot %s /sbin/update-grub 2>&1 | tee -a %s.\n"
              % (target, LOGFILE))
    os.system("echo y | chroot %s /sbin/update-grub 2>&1 | tee -a %s"
              % (target, LOGFILE))

    menu = open("%s/boot/grub/menu.lst" % (target,), "r")
    newmenu = open("%s/boot/grub/menu.lst.new" % (target,), "w")
    line = menu.readline()
    while line:
        newline = re.sub("^# kopt=.*", kopt, line)
        newline = re.sub("^# groot=.*", groot, newline)
        newmenu.write(newline)
        line = menu.readline()
    menu.close()
    newmenu.close()

    os.rename("%s/boot/grub/menu.lst.new" % (target,),
              "%s/boot/grub/menu.lst" % (target,))

    pgi.common.msg("Running echo y | chroot %s /sbin/update-grub 2>&1 | tee -a %s.\n"
              % (target, LOGFILE))
    os.system("echo y | chroot %s /sbin/update-grub 2>&1 | tee -a %s"
              % (target, LOGFILE))

    # Write kernel-img.conf that's consistent with GRUB.
    conf = open("%s/etc/kernel-img.conf" % (target,), "w")
    conf.write("""\
# Turn off Lilo stuff
do_symlinks = no
do_bootloader = no

# Initrds are OK for Grub
do_initrd = yes

# Run cool Grub stuff
postinst_hook = /sbin/update-grub
postrm_hook = /sbin/update-grub
""")
    conf.close()

    return TRUE
