

if ($#ARGV < 0)
{
    print STDERR 
	" $$: $0  @ARGV
 DESCRIPTION
  the input stream is searched for: ITEMCDEF,ITEMXDOC
  
  Each of these ITEMCDEF  will get a number for later reference. 
  The numbered ITEMCDEFS are pushed into an xml-file
  whose filestem is given. In a subdirectory ('c'), each ITEMCDEF
  will get a seperate file. 

  The output file is given as -xml=file, and
  the per-file stem is given as -eachxml=stem (no dot needs to be given)
  
  note: in this version, the output-stream is altered, i.e. the
     ITEMs are numbered for later reference. The number corresponds to
     the individual file numbers.
";
    exit(0);
}

use strict;

my %o;

sub c2x_cdefs_list_item
{
   my ($i,$eachxml,$a,$c,$e,$eachxmlregister) = @_;
   my $F;
   
   if (length $eachxml and open F,">$eachxml.$i")
   {
       print F $a,$c,$e;
       close F;
       $$eachxmlregister 
           .= "\n<XMLFILE>"
           ."\n  <XMLFILENAME>"."$eachxml.$i"."</XMLFILENAME>"
           ."\n  <XMLFILESTEM>".$eachxml."</XMLFILESTEM>"
           ."\n  <XMLFILENUMI>".$i."</XMLFILENUMI>"
           ."\n<XMLFILE>"
           ."\n";
   }
   
   return $a.$c.$e;
}

sub c2x_cdefs_list
{
    my ($in,$xml,$eachxml,$lst) = @_;
    my $i = 10;
    my $F;
    my $fulltext = "";
    my $f;
    my $xmllst ="";
    
    $in =~  s{ <(INFORCSID\b[\ \w]*)> ((?:.(?!</?\1>))*.?) (</\1>) }
             {   $f = c2x_cdefs_list_item($i,$eachxml,"<".$1.">",$2,$3,\$xmllst);
                 $fulltext .= "<ITEMPFESRC>".$f."</ITEMPFESRC>\n\n";
                 ++$i;
                 $f 
             }gsex;

    $in =~  s{ <((?:ITEMCDEF|ITEMXDOC)\b[\ \w]*)> ((?:.(?!</?\1>))*.?) (</\1>) }
             {   $f = c2x_cdefs_list_item($i,$eachxml,"<".$1.">",$2,$3,\$xmllst);
                 $fulltext .= "<ITEMPFESRC>".$f."</ITEMPFESRC>\n\n";
                 ++$i;
                 $f 
             }gsex;

    
    print STDERR "<",$i-10," defs>";
    if (length $xml and open F,">$xml")
    {
       print F $fulltext;
       close F;
    }

    if (length $lst and open F,">$lst")
    {
       print F $xmllst;
       close F;
    }

    return $in;
}

my $T = "";
for (@ARGV)
{
    if (/^-$/) { $T .= join ("",<STDIN>); }
    elsif (/^-([\w-]+)=(.*)/) { $o{$1} = $2; }
    elsif (/^-([\w-]+)/) { $o{$1} = ""; }
    else {
	my $F = $_; 
	if (open F, "<$F") { $T .= join("",<F>); close F; }
	else { die "could not open $F", $1; }
    }
}

$o{xml} = "" if not defined $o{xml};
$o{eachxml} = "" if not defined $o{eachxml};
$o{lst} = "" if not defined $o{lst};

if (length $T)
{
    print c2x_cdefs_list($T, $o{xml}, $o{eachxml}, $o{lst});
}

