
use strict;
use xm::o;
use xm::sub;
use pfe::itemslist;

my $filehash = &xm::o::argv_filehash($pfe::exportlist::DESC);
my $list = &pfe::itemslist::from_filehash($filehash,$o{ext});

my $n;
my @notunique;
for $n (sort keys %$list)
{
    push @notunique, $n if $n =~ m/,/;

    print "<ITEMEXPORT>\n",
    "  <TEXT>",$$list{$n}{text},"</TEXT>\n",
    "  <FILENAME>",$$list{$n}{file},"</FILENAME>\n",
    "  <INDEX>",$$list{$n}{n},"</INDEX>\n",
    "</ITEMEXPORT>\n";
} 

for $n (@notunique)
{
    print "not-unique:\t",$n,"\n";
}

