# -*- Python -*-

if __name__ == '__main__':
    import sys, petsc4py
    petsc4py.init(sys.argv)
    del sys, petsc4py
    

from petsc4py import PETSc
import numpy as array

COMM = PETSc.COMM_WORLD
SIZE = COMM.size
RANK = COMM.rank

opts = PETSc.Options()


#M, N = (100,100)
#M, N = (50,50)
#M, N = (20,20)
#M, N = (10,10)
M, N = (7,7)
#M, N = (5,5)

hx = 1.0/(M-1)
hy = 1.0/(N-1)
ndof = M*N

A = PETSc.Mat()
A.create(comm=COMM)
A.setSizes(ndof)
A.setType(PETSc.Mat.Type.AIJ)
A.setPreallocation([5, 1])

Istart,Iend = A.getOwnershipRange();

for I in xrange(Istart,Iend) :
    v = -1.0; i = I/N; j = I - i*N;
    if i>0   : J = I - N; A[I,J] = v
    if i<M-1 : J = I + N; A[I,J] = v
    if j>0   : J = I - 1; A[I,J] = v
    if j<M-1 : J = I + 1; A[I,J] = v
    v = 4.0;              A[I,I] = v
A.assemble()

is1 = PETSc.ISGeneral([0])
#is1 = PETSc.ISGeneral([0,1,2,3,4,5,6])
#is1 = PETSc.ISGeneral([3,10,17])
#is1 = PETSc.ISGeneral([24])
A.increaseOverlap(is1, 1)
is1.sort()
is1.view()
