#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "npnews.h"

int NP_News::do_connect( const char *server, char *mode )
{
   if ( server == NULL )
   {
      snprintf( error_message, sizeof error_message,
                "NP_News: doconnect(): NULL address passed as argument." );
      return 1;
   }

   if ( mode == NULL || ( strcmp( mode, "r" ) && strcmp( mode, "rw" )))
   {
      snprintf( error_message, sizeof error_message,
                "NP_News: doconnect(): invalid mode: %s", mode );
      return 1;
   }
   
   if ( open_server( server ))
      return 1;
   
   char buffer[ 1024 ];
   char *test;
   int i;
   
   if ( mode[ 1 ] == '\0' )
    {
       test = "20";
       i = 2;
    }
   else
   {
      test = "200";
      i = 3;
   }

   if ( np_fgets( buffer, sizeof buffer ))
      return 1;
   
   if ( strncmp( buffer, test, i ))
   {
      snprintf( error_message, sizeof error_message, "NP_News: "
                "do_connect(): server responded with: %s.", buffer );
      return 1;
   }

   return 0;
}


