#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <gtk/gtk.h>

char *text = NULL;

void close_callback( GtkWidget *widget, gpointer data )
{
   gtk_main_quit();
   return;
}

void buttons_callback( GtkWidget *widget, gpointer data )
{
   GtkWidget *entry = ( GtkWidget *)gtk_object_get_data( GTK_OBJECT( widget ), 
                                                         "entry" );

   if ( data )
      text = gtk_entry_get_text( GTK_ENTRY( entry ));
   else
      text = NULL;

   close_callback( NULL, NULL );

   return;
}
char *insert_newlines( char *before )
{
   char *after;

   if (( text = ( char *)malloc( strlen( before ) + 1 )) == NULL )
   {
      perror( "malloc" );
      exit( 1 );
   }

   after = text;

   while( *before )
   {
      if ( *before == '\\' && *( before + 1 ) == 'n' )
      {
         *after++ = '\n';
         before += 2;
      }
      else
         *after++ = *before++;
   }

   *after = '\0';

   return text; 
}

int main( int argc, char **argv )
{
   if ( argc < 2 )
   {
      fprintf( stderr, "usage: npgettext 'Label string for entry'\n" );
      return 1;
   }

   gtk_init( &argc, &argv );

   GtkWidget *window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
   gtk_signal_connect( GTK_OBJECT( window ), "delete_event",
                       GTK_SIGNAL_FUNC( close_callback ), NULL );
   gtk_signal_connect( GTK_OBJECT( window ), "destroy",
                       GTK_SIGNAL_FUNC( close_callback ), NULL );
   gtk_window_set_title( GTK_WINDOW( window ), "Get Text Dialog" );

   GtkWidget *frame = gtk_frame_new( NULL );
   gtk_widget_show( frame );
   gtk_container_add( GTK_CONTAINER( window ), frame );
   gtk_container_border_width( GTK_CONTAINER( frame ), 10 );

   GtkWidget *vbox = gtk_vbox_new( FALSE, 10 );
   gtk_widget_show( vbox );
   gtk_container_add( GTK_CONTAINER( frame ), vbox );
   gtk_container_border_width( GTK_CONTAINER( vbox ), 10 );

   GtkWidget *label = gtk_label_new( insert_newlines( argv[ 1 ] ));
   gtk_widget_show( label );
   gtk_box_pack_start( GTK_BOX( vbox ), label, FALSE, FALSE, 0 );

   GtkWidget *entry = gtk_entry_new_with_max_length( 100 );
   gtk_widget_show( entry );
   gtk_box_pack_start( GTK_BOX( vbox ), entry, FALSE, FALSE, 0 );

   GtkWidget *hbox = gtk_hbox_new( FALSE, 0 );
   gtk_widget_show( hbox );
   gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, FALSE, 0 );

   GtkWidget *ok_button = gtk_button_new_with_label( " OK " );
   gtk_widget_show( ok_button );
   gtk_box_pack_start( GTK_BOX( hbox ), ok_button, TRUE, FALSE, 0 );
   gtk_object_set_data( GTK_OBJECT( ok_button ), "entry", entry );
   gtk_signal_connect( GTK_OBJECT( ok_button ), "clicked", 
                       GTK_SIGNAL_FUNC( buttons_callback ), ( gpointer)1);

   GtkWidget *cancel_button = gtk_button_new_with_label( " Cancel " );
   gtk_widget_show( cancel_button );
   gtk_object_set_data( GTK_OBJECT( cancel_button ), "entry", entry );
   gtk_box_pack_start( GTK_BOX( hbox ), cancel_button, TRUE, FALSE, 10 );
   gtk_signal_connect( GTK_OBJECT( cancel_button ), "clicked",
                       GTK_SIGNAL_FUNC( buttons_callback ), ( gpointer)0 );

   gtk_widget_show( window );

   gtk_main();

   printf( "%s", (( text == NULL ) ? "(cancelled)" : text ));

   return 0;
}
