#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "npfile.h"
#include "npstringarray.h"
#include "npsubscription.h"

int NP_Subscription::add_group( int i, const char *group,
                                const char *article_no )
{
   const char *pointer;

   if ( group == NULL )
   {
      strcpy( error_message, "NP_Subscription: add_group(): NULL group name"
              " passed as argument." );
      return 1;
   }

   if ( article_no == NULL )
   {
      strcpy( error_message, "NP_Subscription: add_group(): "
              "NULL article number string pass as argument." );
      return 1;
   }
         
   if (( pointer = server_names[ i ] ) == NULL )
   {
      snprintf( error_message, sizeof error_message, "NP_Subscription: "
                "add_group(): %s", server_names.get_error() );
      return 1;
   }

   int result;
   if (( result = group_list[ i ].group_names->add_item( group )))
   {
      snprintf( error_message, sizeof error_message, "NP_Subscription: "
                "add_group(): %s", group_list[ i ].group_names->get_error() );
      return result;
   }

   if ( group_list[ i ].article_nos->add_item( article_no ))
   {
      snprintf( error_message, sizeof error_message, "NP_Subscription: "
                "add_group(): %s", group_list[ i ].article_nos->get_error() );
      return 1;
   }
   
   return 0;
}

int NP_Subscription::add_group( const char *server, const char *group )
{
   if ( group == NULL )
   {
      strcpy( error_message, "NP_Subscription: add_group(): NULL group"
              " name passed as argument." );
      return 1;
   }

   if ( server == NULL )
   {
      strcpy( error_message, "NP_Subscription: add_group(): NULL server"
              " passed as argument." );
      return 1;
   }

   group_list_t *pointer = group_list;

   int i;
   for( i = 0; i < total; ++i )
      if ( !strcmp( pointer++->server, server ))
         break;

   if ( i == total )
   {
      snprintf( error_message, sizeof error_message,
                "NP_Subscription: add_group(): no such server"
                " has been added to this object.", server );
      return 1;
   }

   if ( add_group( i, group, "0" ))
      return 1;

   return 0;
}

