#include <stdlib.h>
#include <stdio.h>

#include "npfile.h"
#include "npstringarray.h"
#include "npgroup.h"
#include "npnode.h"
#include "nptree.h"

int NP_Tree::update_group( char *node, char *group )
{
   if ( node == NULL )
   {
      strcpy( error_message, "NP_Tree: update_group(): NULL node name "
              "passed as argument." );
      return 1;
   }

   if ( group == NULL )
   {
      strcpy( error_message, "NP_Tree: update_group(): NULL group name"
              " passed as argument." );
      return 1;
   }

   NP_Node **pointer = nodes;
   int i;
   for( i = 0; i < total_nodes; ++i )
      if ( !strcmp( ( *pointer )->get_name(), node ))
         break;

   if ( i == total_nodes )
   {
      snprintf( error_message, sizeof error_message, "NP_Tree: "
                "update_groups(): no such node has been created in this"
                " tree object: %s", node );
      return 1;
   }

   if ( ( *pointer )->update_group( group ))
   {
      snprintf( error_message, sizeof error_message, "NP_Tree: update_group():"
                " %s", ( *pointer )->get_error() );
      return 1;
   }
   
   return 0;
}
