/*
 * window_main_burst.cc
 * Copyright (C) Martin Singer 2009-2011 <m_power3@users.sourceforge.net>
 * 
 * pdfchain is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * pdfchain is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "window_main_burst.h"


/*** Combobox : Output ID *****************************************************/

cCBox_CountingMethode::cCBox_CountingMethode()
{
	rLStore		= cLStore_CountingMethode::create();
	pTMCRecord	= rLStore->getTMCRecord();

	pack_start( mCRText );
	add_attribute( mCRText.property_text() , pTMCRecord->mTMColumn_Label );	// necessarily after 'pack_start()' !!!
	set_model( rLStore );
	set_active( 1 );
}


// Destructor
cCBox_CountingMethode::~cCBox_CountingMethode()
{
#ifdef PDFCHAIN_TEST
	std::cout << std::endl << "cCBox_CountingMethode::~cCBox_CountingMethode()";	//TEST
#endif
}



/*** Table Burst **************************************************************/

// Constructor
cTable_Burst::cTable_Burst( Gtk::Window& ref_window )
:
	Gtk::Table( 5 , 6 , false ),	// y_rows , x_columns , homogenous )

	mFCButton_SourceFile( _("Burst - Select source PDF file ...") , Gtk::FILE_CHOOSER_ACTION_OPEN , Pdfchain::Id::FILE_TYPE_PDF ),	// title , action, file type
	mFCDialog_SaveAs( ref_window , _("Burst - Select output folder ...")	, Gtk::FILE_CHOOSER_ACTION_SELECT_FOLDER , false , Pdfchain::Id::FILE_TYPE_ANY ),	// parent_window , title , action , select_multiple , file_type

	mLabel_SourceFile(		_("Source file:")		, Gtk::ALIGN_END	, Gtk::ALIGN_CENTER	, false	),	// label , xalign , yalign , mnemonic
	mLabel_Prefix(			_("Prefix:")			, Gtk::ALIGN_END	, Gtk::ALIGN_CENTER	, false	),
	mLabel_Suffix(			_("Suffix:")			, Gtk::ALIGN_END	, Gtk::ALIGN_CENTER	, false	),
	mLabel_CountingMethod(	_("Counting method:")	, Gtk::ALIGN_END	, Gtk::ALIGN_CENTER	, false	),
	mLabel_CounterDigits(	_("Counter digits:")	, Gtk::ALIGN_END	, Gtk::ALIGN_CENTER	, false	),

	mRBGroup_CounterDigits( mRButton_Auto.get_group() ),
	mRButton_Auto(		mRBGroup_CounterDigits , _("Auto")		, false ),	// group , label , mnemonic
	mRButton_Manual(	mRBGroup_CounterDigits , _("Manual")	, false ),

	mCButton_AddExtension( _("Add extension") , false ),	// label , mnemonic

	rAdjust_Digits( Gtk::Adjustment::create( 0.0 , 0.0 , Pdfchain::Burst::ADJUST_UPPER_DIGITS , 1.0 , 1.0 , 0.0 ) ),	// value , lower , upper , step_inc , page_inc , page_size
	mSButton_Digits( rAdjust_Digits ),

	sPrefix( _("Page") ),
	sSuffix( _("") ),
	vPageNumbers( 0 ),
	vDigits_Oct( 0 ),
	vDigits_Dec( 0 ),
	vDigits_Hex( 0 )
{
	mEntry_Prefix.set_icon_from_stock(	Gtk::Stock::CLEAR , Gtk::ENTRY_ICON_SECONDARY );
	mEntry_Suffix.set_icon_from_stock(	Gtk::Stock::CLEAR , Gtk::ENTRY_ICON_SECONDARY );

	set_border_width( Pdfchain::BORDER );
	set_spacings( Pdfchain::SPACING );
	attach( mLabel_SourceFile		, 0 , 1 , 0 , 1 , Gtk::FILL | Gtk::SHRINK , Gtk::FILL | Gtk::SHRINK , Pdfchain::PADDING , Pdfchain::PADDING );	// row 0 -> 1
	attach( mFCButton_SourceFile	, 1 , 5 , 0 , 1 , Gtk::FILL | Gtk::EXPAND , Gtk::FILL | Gtk::SHRINK , Pdfchain::PADDING , Pdfchain::PADDING );
	attach( mLabel_Prefix			, 0 , 1 , 1 , 2 , Gtk::FILL | Gtk::SHRINK , Gtk::FILL | Gtk::SHRINK , Pdfchain::PADDING , Pdfchain::PADDING );	// row 1 -> 2
	attach( mEntry_Prefix			, 1 , 4 , 1 , 2 , Gtk::FILL | Gtk::SHRINK , Gtk::FILL | Gtk::SHRINK , Pdfchain::PADDING , Pdfchain::PADDING );
	attach( mAlignment_A			, 4 , 5 , 5 , 6 , Gtk::FILL | Gtk::EXPAND , Gtk::FILL | Gtk::SHRINK , Pdfchain::PADDING , Pdfchain::PADDING );
	attach( mLabel_CountingMethod	, 0 , 1 , 2 , 3 , Gtk::FILL | Gtk::SHRINK , Gtk::FILL | Gtk::SHRINK , Pdfchain::PADDING , Pdfchain::PADDING );	// row 2 -> 3
	attach( mCBox_CountingMethod	, 1 , 4 , 2 , 3 , Gtk::FILL | Gtk::SHRINK , Gtk::FILL | Gtk::SHRINK , Pdfchain::PADDING , Pdfchain::PADDING );
	attach( mAlignment_B			, 4 , 5 , 5 , 6 , Gtk::FILL | Gtk::EXPAND , Gtk::FILL | Gtk::SHRINK , Pdfchain::PADDING , Pdfchain::PADDING );
	attach( mLabel_CounterDigits	, 0 , 1 , 3 , 4 , Gtk::FILL | Gtk::SHRINK , Gtk::FILL | Gtk::SHRINK , Pdfchain::PADDING , Pdfchain::PADDING );	// row 3 -> 4
	attach( mRButton_Auto			, 1 , 2 , 3 , 4 , Gtk::FILL | Gtk::SHRINK , Gtk::FILL | Gtk::SHRINK , Pdfchain::PADDING , Pdfchain::PADDING );
	attach( mRButton_Manual			, 2 , 3 , 3 , 4 , Gtk::FILL | Gtk::SHRINK , Gtk::FILL | Gtk::SHRINK , Pdfchain::PADDING , Pdfchain::PADDING );
	attach( mSButton_Digits			, 3 , 4 , 3 , 4 , Gtk::FILL | Gtk::SHRINK , Gtk::FILL | Gtk::SHRINK , Pdfchain::PADDING , Pdfchain::PADDING );
	attach( mAlignment_C			, 4 , 5 , 5 , 6 , Gtk::FILL | Gtk::EXPAND , Gtk::FILL | Gtk::SHRINK , Pdfchain::PADDING , Pdfchain::PADDING );
	attach( mLabel_Suffix			, 0 , 1 , 4 , 5 , Gtk::FILL | Gtk::SHRINK , Gtk::FILL | Gtk::SHRINK , Pdfchain::PADDING , Pdfchain::PADDING );	// row 4 -> 5
	attach( mEntry_Suffix			, 1 , 4 , 4 , 5 , Gtk::FILL | Gtk::SHRINK , Gtk::FILL | Gtk::SHRINK , Pdfchain::PADDING , Pdfchain::PADDING );
	attach( mAlignment_D			, 4 , 5 , 5 , 6 , Gtk::FILL | Gtk::EXPAND , Gtk::FILL | Gtk::SHRINK , Pdfchain::PADDING , Pdfchain::PADDING );
	attach( mAlignment_E			, 0 , 1 , 5 , 6 , Gtk::FILL | Gtk::SHRINK , Gtk::FILL | Gtk::SHRINK , Pdfchain::PADDING , Pdfchain::PADDING );	// row 5 -> 6
	attach( mCButton_AddExtension	, 1 , 4 , 5 , 6 , Gtk::FILL | Gtk::SHRINK , Gtk::FILL | Gtk::SHRINK , Pdfchain::PADDING , Pdfchain::PADDING );
	attach( mAlignment_F			, 4 , 5 , 5 , 6 , Gtk::FILL | Gtk::EXPAND , Gtk::FILL | Gtk::SHRINK , Pdfchain::PADDING , Pdfchain::PADDING );

	mEntry_Prefix.signal_icon_press().connect( sigc::mem_fun( *this , &cTable_Burst::onEntryIcon_Prefix_pressed ) );
	mEntry_Suffix.signal_icon_press().connect( sigc::mem_fun( *this , &cTable_Burst::onEntryIcon_Suffix_pressed ) );
	mCBox_CountingMethod.signal_changed().connect( sigc::mem_fun( *this , &cTable_Burst::onCBox_CountingMethode_changed ) );
	mRButton_Auto.signal_toggled().connect( sigc::mem_fun( *this , &cTable_Burst::onRButton_Auto_toggled ) );
	mFCButton_SourceFile.signal_file_set().connect( sigc::mem_fun( *this , &cTable_Burst::onFCButton_SourceFile_file_set ) );
	
	init();
}


// Destructor
cTable_Burst::~cTable_Burst()
{
#ifdef PDFCHAIN_TEST
	std::cout << std::endl << "cTable_Burst::~cTable_Burst()";	//TEST
#endif
}


// Method (public) : create command
std::string
cTable_Burst::createCommand()
{
	std::string str_command			= "";
	std::string str_sourcefile		= "";
	std::string str_targetfolder	= "";
	std::string str_bursttemplate	= "";
	std::string str_prefix			= Glib::filename_from_utf8( mEntry_Prefix.get_text() );
	std::string str_suffix			= Glib::filename_from_utf8( mEntry_Suffix.get_text() );

	if ( "" != ( str_sourcefile = mFCButton_SourceFile.get_filename() ) ) {
		
		switch ( mFCDialog_SaveAs.run() ) {
			case Gtk::RESPONSE_OK: {
				mFCDialog_SaveAs.hide();

				if ( "" != ( str_targetfolder = mFCDialog_SaveAs.get_current_folder() ) ) {

					Gtk::TreeModel::iterator	iter		= mCBox_CountingMethod.get_active();
					cTMCRecord_Selection*		pt_record	= mCBox_CountingMethod.rLStore->getTMCRecord();

					str_bursttemplate  = str_targetfolder;
					str_bursttemplate += G_DIR_SEPARATOR_S;
					str_bursttemplate += str_prefix;
					str_bursttemplate += Pdfchain::Cmd::TEMPLATE;

					switch( mRButton_Auto.get_active() ) {
						case true:

							switch ( (*iter)[pt_record->mTMColumn_ID] ) {
								case Pdfchain::Id::COUNT_OCT :
									str_bursttemplate += Pdfchain::convert_guint_to_string( vDigits_Oct );
									break;
								case Pdfchain::Id::COUNT_DEC :
									str_bursttemplate += Pdfchain::convert_guint_to_string( vDigits_Dec );
									break;
								case Pdfchain::Id::COUNT_HEX :
									str_bursttemplate += Pdfchain::convert_guint_to_string( vDigits_Hex );
									break;
							}

							break;
						case false:
							str_bursttemplate += mSButton_Digits.get_text();
							break;
					}

					str_bursttemplate += iter->get_value( pt_record->mTMColumn_Command );
					str_bursttemplate += str_suffix;

					if ( mCButton_AddExtension.get_active() )
						str_bursttemplate += Pdfchain::Cmd::EXTENSION;

					str_command  = " " + Pdfchain::quote_path( str_sourcefile );
					str_command += " " + Pdfchain::Cmd::BURST;
					str_command += " " + Pdfchain::Cmd::OUTPUT;
					str_command += " " + Pdfchain::quote_path( str_bursttemplate );
				}
				break;
			}
			default:
				mFCDialog_SaveAs.hide();
				break;
		}
	}
	
	return str_command;
}


// Method (protected) : init()
void 
cTable_Burst::init()
{
	mEntry_Prefix.set_text( sPrefix );
	mEntry_Suffix.set_text( sSuffix );
	mRButton_Auto.set_active( true);
	mSButton_Digits.set_sensitive( false );
	mCBox_CountingMethod.set_active( 1 );
	mCButton_AddExtension.set_active( true );
	
	return;
}