/*
 * window_main_bgst.cc
 * Copyright (C) Martin Singer 2009-2011 <m_power3@users.sourceforge.net>
 * 
 * pdfchain is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * pdfchain is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "window_main_bgst.h"


/*** Table Merge **************************************************************/

// Constructor
cTable_BgSt::cTable_BgSt( Gtk::Window& ref_window )
:
	Gtk::Table( 3 , 7 , false ),	// y_rows , x_columns , homogenous )

	mFCButton_SourceFile(	_("Background / Stamp - Select source PDF file ...")				, Gtk::FILE_CHOOSER_ACTION_OPEN , Pdfchain::Id::FILE_TYPE_PDF ),	// title , action, file type
	mFCButton_BgStFile(		_("Background / Stamp - Select background or stamp PDF file ...")	, Gtk::FILE_CHOOSER_ACTION_OPEN , Pdfchain::Id::FILE_TYPE_PDF ),
	mFCDialog_SaveAs( ref_window , _("Background / Stamp - Save output PDF file as ...") , Pdfchain::Id::FILE_TYPE_PDF ),	// parent_window , title , file_type

	mLabel_SourceFile(	_("Source file:")			, Gtk::ALIGN_END	, Gtk::ALIGN_CENTER	, false	),	// label , xalign , yalign , mnemonic
	mLabel_BgStFile(	_("Backg. / Stamp file:")	, Gtk::ALIGN_END	, Gtk::ALIGN_CENTER	, false	),

	mRBGroup_BgSt( mRButton_Background.get_group() ),
	mRButton_Background(	mRBGroup_BgSt , _("Background")	, false ),	// group , label , mnemonic
	mRButton_Stamp(			mRBGroup_BgSt , _("Stamp")		, false ),

	mCButton_Multi(	_("Multiple background / stamp") , false ),	// label , mnemonic

	mVSeparator( Gtk::ORIENTATION_VERTICAL ),

	vPageNumbers_SourceFile( 0 ),
	vPageNumbers_BgStFile( 0 )
{
	mCButton_Multi.set_active( false );
	
	set_border_width( Pdfchain::BORDER );
	set_spacings( Pdfchain::SPACING );
	attach( mLabel_SourceFile		, 0 , 1 , 0 , 1 , Gtk::FILL | Gtk::SHRINK , Gtk::FILL | Gtk::SHRINK , Pdfchain::PADDING , Pdfchain::PADDING );	// row 0 -> 1
	attach( mFCButton_SourceFile	, 1 , 7 , 0 , 1 , Gtk::FILL | Gtk::EXPAND , Gtk::FILL | Gtk::SHRINK , Pdfchain::PADDING , Pdfchain::PADDING );
	attach( mLabel_BgStFile			, 0 , 1 , 1 , 2 , Gtk::FILL | Gtk::SHRINK , Gtk::FILL | Gtk::SHRINK , Pdfchain::PADDING , Pdfchain::PADDING );	// row 1 -> 2
	attach( mFCButton_BgStFile		, 1 , 7 , 1 , 2 , Gtk::FILL | Gtk::EXPAND , Gtk::FILL | Gtk::SHRINK , Pdfchain::PADDING , Pdfchain::PADDING );
	attach( mAlignment_A			, 0 , 1 , 2 , 3 , Gtk::FILL | Gtk::SHRINK , Gtk::FILL | Gtk::SHRINK , Pdfchain::PADDING , Pdfchain::PADDING );	// row 2 -> 3
	attach( mAlignment_B			, 1 , 2 , 2 , 3 , Gtk::FILL | Gtk::EXPAND , Gtk::FILL | Gtk::SHRINK , Pdfchain::PADDING , Pdfchain::PADDING );
	attach( mRButton_Background		, 2 , 3 , 2 , 3 , Gtk::FILL | Gtk::SHRINK , Gtk::FILL | Gtk::SHRINK , Pdfchain::PADDING , Pdfchain::PADDING );
	attach( mRButton_Stamp			, 3 , 4 , 2 , 3 , Gtk::FILL | Gtk::SHRINK , Gtk::FILL | Gtk::SHRINK , Pdfchain::PADDING , Pdfchain::PADDING );
	attach( mVSeparator				, 4 , 5 , 2 , 3 , Gtk::FILL | Gtk::EXPAND , Gtk::FILL | Gtk::SHRINK , Pdfchain::PADDING , Pdfchain::PADDING );
	attach( mCButton_Multi			, 5 , 6 , 2 , 3 , Gtk::FILL | Gtk::SHRINK , Gtk::FILL | Gtk::SHRINK , Pdfchain::PADDING , Pdfchain::PADDING );
	attach( mAlignment_C			, 6 , 7 , 2 , 3 , Gtk::FILL | Gtk::EXPAND , Gtk::FILL | Gtk::SHRINK , Pdfchain::PADDING , Pdfchain::PADDING );

	mFCButton_SourceFile.signal_file_set().connect( sigc::mem_fun( *this , &cTable_BgSt::onFCButton_SourceFile_file_set ) );
	mFCButton_BgStFile.signal_file_set().connect( sigc::mem_fun( *this , &cTable_BgSt::onFCButton_BgStFile_file_set ) );
	
	init();
}


// Destructor
cTable_BgSt::~cTable_BgSt()
{
#ifdef PDFCHAIN_TEST
	std::cout << std::endl << "cTable_BgSt()::~cTable_BgSt()";	//TEST
#endif
}


// Method (public) : create command
std::string
cTable_BgSt::createCommand()
{
	std::string str_command		= "";
	std::string str_sourcefile	= "";
	std::string str_bgstfile	= "";
	std::string str_targetfile	= "";

	if ( "" != ( str_sourcefile = mFCButton_SourceFile.get_filename() ) ) {
		if ( "" != ( str_bgstfile = mFCButton_BgStFile.get_filename() ) ) {

			switch ( mFCDialog_SaveAs.run() ) {
				case Gtk::RESPONSE_OK:
					mFCDialog_SaveAs.hide();

					if ( "" != ( str_targetfile = mFCDialog_SaveAs.get_filename() ) ) {
						str_command = " " + Pdfchain::quote_path( str_sourcefile );

						switch ( mRButton_Background.get_active() ) {
							case true:

								switch ( mCButton_Multi.get_active() ) {
									case true:	str_command += " " + Pdfchain::Cmd::BACKGROUND_MULTI;	break;
									case false:	str_command += " " + Pdfchain::Cmd::BACKGROUND;			break;
								}
								break;
							case false:

								switch ( mCButton_Multi.get_active() ) {
									case true:	str_command += " " + Pdfchain::Cmd::STAMP_MULTI;		break;
									case false:	str_command += " " + Pdfchain::Cmd::STAMP;				break;
								}
								break;
						}

						str_command += " " + Pdfchain::quote_path( str_bgstfile );
						str_command += " " + Pdfchain::Cmd::OUTPUT;
						str_command += " " + Pdfchain::quote_path( str_targetfile );
					}
					break;
					
				default:
					mFCDialog_SaveAs.hide();
					break;
			}
		}
	}
	
	return str_command;
}


// Method (protected) : init()
void
cTable_BgSt::init()
{
	mRButton_Background.set_active( true );
	
	return;
}