/*
 * window_main.h
 * Copyright (C) Martin Singer 2009-2011 <m_power3@users.sourceforge.net>
 * 
 * pdfchain is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * pdfchain is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PDFCHAIN_WINDOW_MAIN_H
#define PDFCHAIN_WINDOW_MAIN_H

#include "pdfchain.h"
#include "dialog.h"
#include "window_main_cat.h"
#include "window_main_burst.h"
#include "window_main_bgst.h"
#include "window_main_attach.h"
#include "window_main_tool.h"
#include "window_main_permission.h"


/*** Menu : Main **************************************************************/

class
cMenu_Main
{
	public:

		cMenu_Main( Gtk::Window* );
		virtual ~cMenu_Main();

		Gtk::Widget* getWidget() {
			return rUIManager->get_widget("/menu_main");
		}

	protected:

		Gtk::Window* pWindow;
		
		Glib::RefPtr<Gtk::UIManager>	rUIManager;
		Glib::RefPtr<Gtk::ActionGroup>	rAGroup;

		cDialog_About	mDialog_About;

		//void onFile_New(){}
		void onFile_Quit() { pWindow->hide(); }
		//void onFile_CopyCommand(){}
		//void onHelp_Homepage(){}
		//void onHelp_Translate(){}
		//void onHelp_Help(){}
		
		void onHelp_About() {
			mDialog_About.run();
			mDialog_About.hide();
			return;
		}
};



/*** Notebook : Sections ******************************************************/

class
cNotebook_Sections : public Gtk::Notebook
{
	friend class cWindow_Main;
	
	public:

		cNotebook_Sections( Gtk::Window& );
		virtual ~cNotebook_Sections();
		
	protected:

		Gtk::Label	mLabel_Cat,
					mLabel_Burst,
					mLabel_BgSt,
					mLabel_Attach,
					mLabel_Tool;
		
		cVBox_Cat		mSection_Cat;
		cTable_Burst	mSection_Burst;
		cTable_BgSt		mSection_BgSt;
		cVBox_Attach	mSection_Attach;
		cVBox_Tool		mSection_Tool;
};



/*** HBox : Save **************************************************************/

class
cHBox_Save : public Gtk::HBox
{
	friend class cWindow_Main;
	
	public:

		cHBox_Save();
		virtual ~cHBox_Save();

	protected:

		Gtk::ProgressBar	mPBar_Save;
		Gtk::Button			mButton_SaveAs;
};



/*** Window : Main ************************************************************/

class
cWindow_Main : public Gtk::Window
{
	public:

		cWindow_Main();
		virtual ~cWindow_Main();
		
	protected:

		sigc::connection		mConnection_NotebookSections_signal_switch_page;

		cMenu_Main				mMenu_Main;
		Gtk::VBox				mVBox_Main,
								mVBox_Content;
		Gtk::Widget*			pWidget_Menu;
		Gtk::Alignment			mAlign_Content;
		cNotebook_Sections		mNotebook_Sections;
		cExpander_Permissions	mExpander_Permissions;
		cHBox_Save				mHBox_Save;
		Gtk::Statusbar			mSBar_Main;
		cMDialog_PdftkError		mMDialog_PdftkError;

		void confirmErrorCode( int );

		void onNotebook_Sections_switch_page( Widget* , guint );
		void onButton_SaveAs_clicked();
};


#endif