/*
 * store_cat.h
 * Copyright (C) Martin Singer 2009-2011 <m_power3@users.sourceforge.net>
 * 
 * pdfchain is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * pdfchain is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PDFCHAIN_WINDOW_STORE_CAT_H
#define PDFCHAIN_WINDOW_STORE_CAT_H

#include "pdfchain.h"
#include "store.h"
#include "dialog_filechooser.h"
#include "dialog.h"


/*** Tree Model Column Record : Cat *******************************************/

class
cTMCRecord_Cat : public Gtk::TreeModel::ColumnRecord
{
	public:

		cTMCRecord_Cat() {
			add( mTMColumn_Add					);
			add( mTMColumn_Pages				);
			add( mTMColumn_EvenOdd				);
			add( mTMColumn_Rotation				);
			add( mTMColumn_SourceFile			);
			add( mTMColumn_SourcePath			);
			add( mTMColumn_Tooltip				);
			add( mTMColumn_Password				);
			add( mTMColumn_PageNumbers			);
			add( mTMColumn_Cmd_Handle			);
			add( mTMColumn_Cmd_EvenOdd			);
			add( mTMColumn_Cmd_Rotation			);
			add( mTMColumn_Color_Pages			);
			add( mTMColumn_Color_PageNumbers	);
		}

		virtual ~cTMCRecord_Cat() {
#ifdef PDFCHAIN_TEST
			std::cout << std::endl << "cTMCRecord_Cat::~cTMCRecord_Cat()";	//TEST
#endif
		}

		Gtk::TreeModelColumn<gboolean>		mTMColumn_Add;
		Gtk::TreeModelColumn<Glib::ustring>	mTMColumn_Pages;
		Gtk::TreeModelColumn<Glib::ustring>	mTMColumn_EvenOdd;
		Gtk::TreeModelColumn<Glib::ustring>	mTMColumn_Rotation;
		Gtk::TreeModelColumn<Glib::ustring>	mTMColumn_SourceFile;
		Gtk::TreeModelColumn<std::string>	mTMColumn_SourcePath;
		Gtk::TreeModelColumn<Glib::ustring>	mTMColumn_Tooltip;
		Gtk::TreeModelColumn<Glib::ustring>	mTMColumn_Password;
		Gtk::TreeModelColumn<guint>			mTMColumn_PageNumbers;
		Gtk::TreeModelColumn<guchar>		mTMColumn_Cmd_Handle;
		Gtk::TreeModelColumn<std::string>	mTMColumn_Cmd_EvenOdd;
		Gtk::TreeModelColumn<std::string>	mTMColumn_Cmd_Rotation;
		Gtk::TreeModelColumn<Gdk::RGBA>		mTMColumn_Color_Pages;
		Gtk::TreeModelColumn<Gdk::RGBA>		mTMColumn_Color_PageNumbers;
};



/*** List Store : Cat *********************************************************/

class
cLStore_Cat : public Gtk::ListStore
{
	public:

		cLStore_Cat( Gtk::Window& );
		virtual ~cLStore_Cat();
		
		static Glib::RefPtr<cLStore_Cat> create( Gtk::Window& ref_window ) { return Glib::RefPtr<cLStore_Cat>( new cLStore_Cat( ref_window ) ); }
		cTMCRecord_Cat* getTMCRecord() { return pTMCRecord; }

		void addRows		( Glib::RefPtr<Gtk::TreeSelection> );
		void removeRows		( Glib::RefPtr<Gtk::TreeSelection> );
		void copyRows		( Glib::RefPtr<Gtk::TreeSelection> );
		void moveRowsUp		( Glib::RefPtr<Gtk::TreeSelection> );
		void moveRowsDown	( Glib::RefPtr<Gtk::TreeSelection> );

		void toggleAdd( const Gtk::TreePath& );
		void editPages( const Gtk::TreePath& , const Glib::ustring& );
		void changeEvenOdd( const Gtk::TreePath& , const Glib::ustring& , const std::string& );
		void changeRotation( const Gtk::TreePath& , const Glib::ustring& , const std::string& );
		void editPassword( const Gtk::TreePath& , const Glib::ustring& );

		std::string createCommand( bool );

		sigc::signal<void , guchar> signalFileNumber_changed() {
			return mSignal_FileNumber_changed;
		}

	protected:

		guchar vFileNumber;

		cTMCRecord_Cat*			pTMCRecord;
		cFCDialog_Cat_AddFiles	mFCDialog;
		cMDialog_Password		mMDialog_Password;

		void		indicateHandles();
		gboolean	validatePages( const Gtk::TreeModel::iterator& );
		void		copyRow( const Gtk::TreeModel::iterator& , const Gtk::TreeModel::iterator& );

		sigc::signal<void , guchar> mSignal_FileNumber_changed;
};


#endif