/*
 * dialog_filechooser_extension.h
 * Copyright (C) Martin Singer 2009-2011 <m_power3@users.sourceforge.net>
 * 
 * pdfchain is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * pdfchain is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PDFCHAIN_DIALOG_FILECHOOSER_EXTENSION_H
#define PDFCHAIN_DIALOG_FILECHOOSER_EXTENSION_H

#include "pdfchain.h"
#include "store.h"


/*** File Filter **************************************************************/

// File Filter : Any Files
class
cFFilter_Any : public Gtk::FileFilter
{
	public:

		cFFilter_Any() {
			
			set_name( _("Any files") );
			add_pattern( "*" );
		}

		virtual ~cFFilter_Any() {
#ifdef PDFCHAIN_TEST
			std::cout << std::endl << "cFFilter_Any::~cFFilter_Any()";	//TEST
#endif
		}
};


// File Filter : PDF Files
class
cFFilter_Pdf : public Gtk::FileFilter
{
	public:

		cFFilter_Pdf() {
			
			set_name( _("PDF files") );
			add_mime_type( "application/pdf" );
			//add_pattern( "*.pdf" );
		}

		virtual ~cFFilter_Pdf() {
#ifdef PDFCHAIN_TEST
			std::cout << std::endl << "cFFilter_Pdf::~cFFilter_Pdf()";	//TEST
#endif
		}
};


// File Filter : Text Files
class
cFFilter_Text : public Gtk::FileFilter
{
	public:

		cFFilter_Text() {
			
			set_name( _("Text files") );
			add_mime_type( "text/plain" );
			//add_pattern( "*.txt" );
		}

		virtual ~cFFilter_Text() {
#ifdef PDFCHAIN_TEST
			std::cout << std::endl << "cFFilter_Text::~cFFilter_Text()";	//TEST
#endif
		}
};


// File Filter : FDF Files
class
cFFilter_Fdf : public Gtk::FileFilter
{
	public:

		cFFilter_Fdf() {
			
			set_name( _("FDF files") );
			//add_mime_type( "text/plain" );
			add_pattern( "*.fdf" );
		}

		virtual ~cFFilter_Fdf() {
#ifdef PDFCHAIN_TEST
			std::cout << std::endl << "cFFilter_Fdf::~cFFilter_Fdf()";	//TEST
#endif
		}
};


// File Filter : Dump Files
class
cFFilter_Dump : public Gtk::FileFilter
{
	public:

		cFFilter_Dump() {
			
			set_name( _("Dump files") );
			//add_mime_type( "text/plain" );
			add_pattern( "*.dump" );
		}

		virtual ~cFFilter_Dump() {
#ifdef PDFCHAIN_TEST
			std::cout << std::endl << "cFFilter_Dump::~cFFilter_Dump()";	//TEST
#endif
		}
};



/*** Expander : Cat Options ***************************************************/

// ComboBox : Cat Options - Even Odd
class
cCBox_CatOptions_EvenOdd : public Gtk::ComboBox
{
	public:

		cCBox_CatOptions_EvenOdd();
		virtual ~cCBox_CatOptions_EvenOdd();

		Glib::RefPtr<cLStore_EvenOdd>	rLStore;
		Gtk::CellRendererText			mCRText;
		cTMCRecord_Selection*			pTMCRecord;		
};


// ComboBox : Cat Options - Rotation
class
cCBox_CatOptions_Rotation : public Gtk::ComboBox
{
	public:

		cCBox_CatOptions_Rotation();
		virtual ~cCBox_CatOptions_Rotation();
		
		Glib::RefPtr<cLStore_Rotation>	rLStore;
		Gtk::CellRendererText			mCRText;
		cTMCRecord_Selection*			pTMCRecord;		
};


// Expander : Cat Options
class
cExpander_CatOptions : public Gtk::Expander
{
	friend class cFCDialog_Cat_AddFiles;
	
	public:

		cExpander_CatOptions();
		virtual ~cExpander_CatOptions();

	protected:

		Glib::ustring				sPages;
		
		Gtk::HBox					mHBox_Options;
		Gtk::Label					mLabel_Pages,
									mLabel_Rotation,
									mLabel_Password;
		Gtk::Entry					mEntry_Pages,
									mEntry_Password;
		Gtk::Separator				mSeparator_A,
									mSeparator_B;
		cCBox_CatOptions_EvenOdd	mCBox_EvenOdd;
		cCBox_CatOptions_Rotation	mCBox_Rotation;

		void onEntryIcon_Pages_pressed( Gtk::EntryIconPosition icon_pos , const GdkEventButton* event ) {
			mEntry_Pages.set_text( sPages );
			return;
		}

		void onEntryIcon_Password_pressed( Gtk::EntryIconPosition icon_pos , const GdkEventButton* event ) {
			mEntry_Password.set_text("");
			return;
		}
};


#endif