/*
**  UUFile.m
**
**  Copyright (c) 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**  
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**  
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#include <Pantomime/UUFile.h>

#include <Pantomime/Constants.h>


//
//
//
@implementation UUFile

- (id) initWithName: (NSString *) theName
	       data: (NSData *) theData
	 attributes: (NSDictionary *) theAttributes
{
  self = [super init];

  [self setName: theName];
  [self setData: theData];
  [self setAttributes: theAttributes];

  return self;
}


//
//
//
- (void) dealloc
{
  RELEASE(name);
  RELEASE(data);
  RELEASE(attributes);

  [super dealloc];
}


//
// access / mutation methods
//
- (NSString *) name
{
  return name;
}

- (void) setName: (NSString *) theName
{
  if ( theName )
    {
      RETAIN(theName);
      RELEASE(name);
      name = theName;
    }
  else
    {
      DESTROY(name);
    }
}


//
//
//
- (NSData *) data
{
  return data;
}

- (void) setData: (NSData *) theData
{
  if ( theData )
    {
      RETAIN(theData);
      RELEASE(data);
      data = theData;
    }
  else
    {
      DESTROY(data);
    }
}


//
//
//
- (NSDictionary *) attributes
{
  return attributes;
}

- (void) setAttributes: (NSDictionary *) theAttributes
{
  if ( theAttributes )
    {
      RETAIN(theAttributes);
      RELEASE(attributes);
      attributes = theAttributes;
    }
  else
    {
      DESTROY(attributes);
    }
}


@end
